// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_FunctionSample_HeaderFile
#define _math_FunctionSample_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class gives a default sample (constant difference <br>
//!          of parameter) for a function defined between <br>
//!          two bound A,B. <br>
class math_FunctionSample  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT math_FunctionSample(const Standard_Real A,const Standard_Real B,const Standard_Integer N);

//! Returns the bounds of parameters. <br>
Standard_EXPORT virtual  void Bounds(Standard_Real& A,Standard_Real& B) const;

//! Returns the number of sample points. <br>
Standard_EXPORT   Standard_Integer NbPoints() const;

//! Returns the value of parameter of the point of <br>
//!          range Index : A + ((Index-1)/(NbPoints-1))*B. <br>
//!          An exception is raised if Index<=0 or Index>NbPoints. <br>
Standard_EXPORT virtual  Standard_Real GetParameter(const Standard_Integer Index) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real a;
Standard_Real b;
Standard_Integer n;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
