// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_FunctionRoots_HeaderFile
#define _math_FunctionRoots_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_RangeError;
class StdFail_NotDone;
class math_FunctionWithDerivative;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements an algorithm which finds all the real roots of <br>
//! a function with derivative within a given range. <br>
//! Knowledge of the derivative is required. <br>
class math_FunctionRoots  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Calculates all the real roots of a function F-K within the range <br>
//! A..B. whithout conditions on A and B <br>
//! A solution X is found when <br>
//!   abs(Xi - Xi-1) <= Epsx and abs(F(Xi)-K) <= EpsF. <br>
//! The function is considered as null between A and B if <br>
//! abs(F-K) <= EpsNull within this range. <br>
Standard_EXPORT math_FunctionRoots(math_FunctionWithDerivative& F,const Standard_Real A,const Standard_Real B,const Standard_Integer NbSample,const Standard_Real EpsX = 0.0,const Standard_Real EpsF = 0.0,const Standard_Real EpsNull = 0.0,const Standard_Real K = 0.0);
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;

//! returns true if the function is considered as null between A and B. <br>
//! Exceptions <br>
//! StdFail_NotDone if the algorithm fails (and IsDone returns false). <br>
  Standard_Boolean IsAllNull() const;
//! Returns the number of solutions found. <br>
//! Exceptions <br>
//! StdFail_NotDone if the algorithm fails (and IsDone returns false). <br>
  Standard_Integer NbSolutions() const;
//! Returns the Nth value of the root of function F. <br>
//! Exceptions <br>
//! StdFail_NotDone if the algorithm fails (and IsDone returns false). <br>
  Standard_Real Value(const Standard_Integer Nieme) const;

//! returns the StateNumber  of the Nieme root. <br>
//! Exception RangeError is raised if Nieme is < 1 <br>
//!  or Nieme > NbSolutions. <br>
  Standard_Integer StateNumber(const Standard_Integer Nieme) const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;
Standard_Boolean AllNull;
TColStd_SequenceOfReal Sol;
TColStd_SequenceOfInteger NbStateSol;


};


#include <math_FunctionRoots.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
