// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _XCAFDoc_LayerTool_HeaderFile
#define _XCAFDoc_LayerTool_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_XCAFDoc_LayerTool_HeaderFile
#include <Handle_XCAFDoc_LayerTool.hxx>
#endif

#ifndef _Handle_XCAFDoc_ShapeTool_HeaderFile
#include <Handle_XCAFDoc_ShapeTool.hxx>
#endif
#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfExtendedString_HeaderFile
#include <Handle_TColStd_HSequenceOfExtendedString.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
class XCAFDoc_ShapeTool;
class TDF_Label;
class Standard_GUID;
class TCollection_ExtendedString;
class TDF_LabelSequence;
class TColStd_HSequenceOfExtendedString;
class TopoDS_Shape;
class TDF_Attribute;
class TDF_RelocationTable;


//! Provides tools to store and retrieve attributes (Layers) <br>
//!          of TopoDS_Shape in and from TDocStd_Document <br>
//!          A Document is intended to hold different <br>
//!          attributes of ONE shape and it's sub-shapes <br>
class XCAFDoc_LayerTool : public TDF_Attribute {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT XCAFDoc_LayerTool();

//! Creates (if not exist) LayerTool. <br>
Standard_EXPORT static  Handle_XCAFDoc_LayerTool Set(const TDF_Label& L) ;


Standard_EXPORT static const Standard_GUID& GetID() ;

//! returns the label under which Layers are stored <br>
Standard_EXPORT   TDF_Label BaseLabel() const;

//! Returns internal XCAFDoc_ShapeTool tool <br>
Standard_EXPORT  const Handle_XCAFDoc_ShapeTool& ShapeTool() ;

//! Returns True if label belongs to a Layertable and <br>
//!          is a Layer definition <br>
Standard_EXPORT   Standard_Boolean IsLayer(const TDF_Label& lab) const;

//! Returns Layer defined by label lab <br>
//!          Returns False if the label is not in Layertable <br>
//!          or does not define a Layer <br>
Standard_EXPORT   Standard_Boolean GetLayer(const TDF_Label& lab,TCollection_ExtendedString& aLayer) const;

//! Finds a Layer definition in a Layertable and returns <br>
//!          its label if found <br>
//!          Returns False if Layer is not found in Layertable <br>
Standard_EXPORT   Standard_Boolean FindLayer(const TCollection_ExtendedString& aLayer,TDF_Label& lab) const;

//! Finds a Layer definition in a Layertable and returns <br>
//!          its label if found (or Null label else) <br>
Standard_EXPORT   TDF_Label FindLayer(const TCollection_ExtendedString& aLayer) const;

//! Adds a Layer definition to a Layertable and returns <br>
//!          its label (returns existing label if the same Layer <br>
//!          is already defined) <br>
Standard_EXPORT   TDF_Label AddLayer(const TCollection_ExtendedString& aLayer) const;

//! Removes Layer from the Layertable <br>
Standard_EXPORT   void RemoveLayer(const TDF_Label& lab) const;

//! Returns a sequence of Layers currently stored <br>
//!          in the Layertable <br>
Standard_EXPORT   void GetLayerLabels(TDF_LabelSequence& Labels) const;

//! Sets a link from label <L> to Layer <br>
//!          defined by <LayerL> <br>
//!          optional parametr <shapeInOneLayer> show could shape be <br>
//!          in number of layers or only in one. <br>
Standard_EXPORT   void SetLayer(const TDF_Label& L,const TDF_Label& LayerL,const Standard_Boolean shapeInOneLayer = Standard_False) const;

//! Sets a link from label <L> to Layer <aLayer> <br>
//!          in the Layertable <br>
//!          Adds a Layer as necessary <br>
//!          optional parametr <shapeInOneLayer> show could shape be <br>
//!          in number of layers or only in one. <br>
Standard_EXPORT   void SetLayer(const TDF_Label& L,const TCollection_ExtendedString& aLayer,const Standard_Boolean shapeInOneLayer = Standard_False) const;

//! Removes a link from label <L> to all layers <br>
Standard_EXPORT   void UnSetLayers(const TDF_Label& L) const;

//! Remove link from label <L> and Layer <aLayer>. <br>
//!          returns FALSE if no such layer. <br>
Standard_EXPORT   Standard_Boolean UnSetOneLayer(const TDF_Label& L,const TCollection_ExtendedString& aLayer) const;

//! Returns True if label <L> has a Layer assosiated <br>
//!          with the <aLayer>. <br>
Standard_EXPORT   Standard_Boolean IsSet(const TDF_Label& L,const TCollection_ExtendedString& aLayer) const;

//! Return sequence of strings <aLayerS> that assosiated with label <L>. <br>
Standard_EXPORT   Standard_Boolean GetLayers(const TDF_Label& L,Handle(TColStd_HSequenceOfExtendedString)& aLayerS) ;

//! Return sequence of strings that assosiated with label <L>. <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfExtendedString GetLayers(const TDF_Label& L) ;

//! Return sequanese of shape labels that assigned with layers to <ShLabels>. <br>
Standard_EXPORT   void GetShapesOfLayer(const TDF_Label& layerL,TDF_LabelSequence& ShLabels) const;

//! Return TRUE if layer is visible, FALSE if invisible. <br>
Standard_EXPORT   Standard_Boolean IsVisible(const TDF_Label& layerL) const;

//! Set the visibility of layer. If layer is invisible when on it's layer <br>
//!          will set UAttribute with corresponding GUID. <br>
Standard_EXPORT   void SetVisibility(const TDF_Label& layerL,const Standard_Boolean isvisible = Standard_True) const;

//! Sets a link from label that containig shape <Sh> <br>
//!          with layer that situated at label <LayerL>. <br>
//!          optional parametr <shapeInOneLayer> show could shape be <br>
//!          in number of layers or only in one. <br>
//!          return FALSE if no such shape <Sh> or label <LayerL> <br>
Standard_EXPORT   Standard_Boolean SetLayer(const TopoDS_Shape& Sh,const TDF_Label& LayerL,const Standard_Boolean shapeInOneLayer = Standard_False) ;

//! Sets a link from label that containig shape <Sh> <br>
//!          with layer <aLayer>. Add <aLayer> to LayerTable if nessesery. <br>
//!          optional parametr <shapeInOneLayer> show could shape be <br>
//!          in number of layers or only in one. <br>
//!          return FALSE if no such shape <Sh>. <br>
Standard_EXPORT   Standard_Boolean SetLayer(const TopoDS_Shape& Sh,const TCollection_ExtendedString& aLayer,const Standard_Boolean shapeInOneLayer = Standard_False) ;

//! Remove link between shape <Sh> and all Layers at LayerTable. <br>
//!          return FALSE if no such shape <Sh> in XCAF Document. <br>
Standard_EXPORT   Standard_Boolean UnSetLayers(const TopoDS_Shape& Sh) ;

//! Remove link between shape <Sh> and layer <aLayer>. <br>
//!          returns FALSE if no such layer <aLayer> or shape <Sh>. <br>
Standard_EXPORT   Standard_Boolean UnSetOneLayer(const TopoDS_Shape& Sh,const TCollection_ExtendedString& aLayer) ;

//! Returns True if shape <Sh> has a Layer assosiated <br>
//!          with the <aLayer>. <br>
Standard_EXPORT   Standard_Boolean IsSet(const TopoDS_Shape& Sh,const TCollection_ExtendedString& aLayer) ;

//! Return sequence of strings <aLayerS> that assosiated with shape <Sh>. <br>
Standard_EXPORT   Standard_Boolean GetLayers(const TopoDS_Shape& Sh,Handle(TColStd_HSequenceOfExtendedString)& aLayerS) ;

//! Return sequence of strings that assosiated with shape <Sh>. <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfExtendedString GetLayers(const TopoDS_Shape& Sh) ;


Standard_EXPORT  const Standard_GUID& ID() const;


Standard_EXPORT   void Restore(const Handle(TDF_Attribute)& with) ;


Standard_EXPORT   Handle_TDF_Attribute NewEmpty() const;


Standard_EXPORT   void Paste(const Handle(TDF_Attribute)& into,const Handle(TDF_RelocationTable)& RT) const;
//Standard_EXPORT ~XCAFDoc_LayerTool();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_XCAFDoc_ShapeTool myShapeTool;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
