// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKernel_Entity_HeaderFile
#define _WOKernel_Entity_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WOKernel_Entity_HeaderFile
#include <Handle_WOKernel_Entity.hxx>
#endif

#ifndef _WOKUtils_Param_HeaderFile
#include <WOKUtils_Param.hxx>
#endif
#ifndef _Handle_WOKernel_FileTypeBase_HeaderFile
#include <Handle_WOKernel_FileTypeBase.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_WOKernel_HSequenceOfStationID_HeaderFile
#include <Handle_WOKernel_HSequenceOfStationID.hxx>
#endif
#ifndef _Handle_WOKernel_HSequenceOfDBMSID_HeaderFile
#include <Handle_WOKernel_HSequenceOfDBMSID.hxx>
#endif
#ifndef _WOKernel_BaseEntity_HeaderFile
#include <WOKernel_BaseEntity.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_WOKernel_FileType_HeaderFile
#include <Handle_WOKernel_FileType.hxx>
#endif
#ifndef _Handle_WOKUtils_HSequenceOfParamItem_HeaderFile
#include <Handle_WOKUtils_HSequenceOfParamItem.hxx>
#endif
class WOKernel_FileTypeBase;
class WOKernel_HSequenceOfStationID;
class WOKernel_HSequenceOfDBMSID;
class Standard_ProgramError;
class TCollection_HAsciiString;
class WOKUtils_Param;
class WOKernel_FileType;
class WOKUtils_HSequenceOfParamItem;


//! Base class of WOK entities (Factories, Warehouses, <br>
//!          Workshops, Workbenches, Development units.) <br>
//! <br>
class WOKernel_Entity : public WOKernel_BaseEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT virtual  Handle_TCollection_HAsciiString EntityCode() const = 0;


Standard_EXPORT   void GetParams() ;

//! change Parameters of Entity <br>
Standard_EXPORT   void SetParams(const WOKUtils_Param& aparam) ;
//! Get parameters of Entity <br>
  WOKUtils_Param& ChangeParams() ;
//! Get parameters of Entity <br>
 const WOKUtils_Param& Params() const;


Standard_EXPORT   Handle_TCollection_HAsciiString ParameterName(const Standard_CString aname) const;

//! Evaluates a parameter for the entity <br>
//!          Name_<aparamname> is evaluated <br>
Standard_EXPORT   Handle_TCollection_HAsciiString EvalParameter(const Standard_CString aparamname,const Standard_Boolean isnecessary = Standard_True) const;

//! Looks up for a default value to Parameter <aparamname> <br>//! Sets profile parameters <br>
//!              %Station = ao1|sun|hp|sil <br>
//!              %DBMS    = MEM|OBJY|OBJS|OO2 <br>
//!              %Nesting_Station = %Nesting_%Station <br>
//!              %Nesting_DBMS    = %Nesting_%DBMS <br>
Standard_EXPORT   Handle_TCollection_HAsciiString EvalDefaultParameterValue(const Handle(TCollection_HAsciiString)& aparamname,const Standard_Integer evaldepth = 0) ;


Standard_EXPORT   Handle_WOKernel_FileTypeBase FileTypeBase() const;


Standard_EXPORT   Handle_WOKernel_FileType GetFileType(const Handle(TCollection_HAsciiString)& atypename) const;


Standard_EXPORT   Handle_WOKernel_FileType GetFileType(const Standard_CString atypename) const;

//! Dumps in a file the construction parameters of Entity <br>
Standard_EXPORT   void DumpBuildParameters(const Handle(WOKUtils_HSequenceOfParamItem)& aparamseq) const;

//! constructs Sequence of Parameters Needed by Entity <br>
//!          to be built. <br>
//!          Checks their consistancy <br>
Standard_EXPORT virtual  Handle_WOKUtils_HSequenceOfParamItem BuildParameters(const Handle(WOKUtils_HSequenceOfParamItem)& someparams,const Standard_Boolean usedefaults) ;

//! Checks if name given to the entity is valid <br>
//!          (forbidden characters are : " /<>\{}*~" <br>
Standard_EXPORT virtual  Standard_Boolean IsValidName() const;

//! Checks if name given to the entity is valid <br>
//!          (forbidden characters are : " /<>\{}*~_" <br>
Standard_EXPORT static  Standard_Boolean IsValidName(const Handle(TCollection_HAsciiString)& aname) ;

//! Creates On disk the Entity <br>
//!          it must neither be opened or existing <br>
//!          Parameters must all be present in someparams <br>
Standard_EXPORT virtual  void Build(const Handle(WOKUtils_HSequenceOfParamItem)& someparams) ;

//! Destroys Entity on Disk <br>
//!          it must not be opened <br>
Standard_EXPORT virtual  void Destroy() ;

//! open an existing entity <br>
Standard_EXPORT virtual  void Open()  = 0;

//! Flag Entity as Opened <br>
Standard_EXPORT   void SetOpened() ;

//! resets Entity fields (eq:Close) <br>
Standard_EXPORT virtual  void Reset() ;

//! closes entity <br>
Standard_EXPORT virtual  void Close()  = 0;

//! flag entity as closed <br>
Standard_EXPORT   void SetClosed() ;
//! tests if Entity is opened <br>
  Standard_Boolean IsOpened() const;

//! Calcultes the unique name of base entity <br>
Standard_EXPORT virtual  Handle_TCollection_HAsciiString GetUniqueName() const;

//! Calculates the unique name of an Entity Nested in Entity <br>
Standard_EXPORT   Handle_TCollection_HAsciiString NestedUniqueName(const Handle(TCollection_HAsciiString)& aname) const;


Standard_EXPORT   Handle_WOKernel_HSequenceOfStationID Stations() const;


Standard_EXPORT   Handle_WOKernel_HSequenceOfDBMSID DBMSystems() const;

//! Destroys The Entity <br>
Standard_EXPORT   void Kill() ;
~WOKernel_Entity()
{
  Kill();
}





 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Initialize a WOKernel Entity <br>
Standard_EXPORT WOKernel_Entity(const Handle(TCollection_HAsciiString)& aname,const Handle(WOKernel_Entity)& anesting);


Standard_EXPORT virtual  void GetParameters() ;


Standard_EXPORT   void SetFileTypeBase(const Handle(WOKernel_FileTypeBase)& abase) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
WOKUtils_Param myparams;
Handle_WOKernel_FileTypeBase mytypes;
Standard_Boolean myopenstatus;
Handle_WOKernel_HSequenceOfStationID mystations;
Handle_WOKernel_HSequenceOfDBMSID mydbmss;


};


#include <WOKernel_Entity.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
