// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_WWWInline_HeaderFile
#define _Vrml_WWWInline_HeaderFile

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TCollection_AsciiString;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! defines a WWWInline node of VRML specifying group properties. <br>
//!  The  WWWInline  group  node  reads  its  children  from  anywhere  in  the <br>
//!  World  Wide  Web. <br>
//!  Exactly  when  its  children  are  read  is  not  defined; <br>
//!  reading  the  children  may  be  delayed  until  the  WWWInline  is  actually <br>
//!  displayed. <br>
//!  WWWInline  with  an  empty  ("")  name  does  nothing. <br>
//!  WWWInline  behaves  like  a  Separator,  pushing  the  traversal  state <br>
//!  before  traversing  its  children  and  popping  it  afterwards. <br>
//!  By  defaults: <br>
//!    myName  ("") <br>
//!    myBboxSize (0,0,0) <br>
//!    myBboxCenter  (0,0,0) <br>
class Vrml_WWWInline  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_WWWInline();


Standard_EXPORT Vrml_WWWInline(const TCollection_AsciiString& aName,const gp_Vec& aBboxSize,const gp_Vec& aBboxCenter);


Standard_EXPORT   void SetName(const TCollection_AsciiString& aName) ;


Standard_EXPORT   TCollection_AsciiString Name() const;


Standard_EXPORT   void SetBboxSize(const gp_Vec& aBboxSize) ;


Standard_EXPORT   gp_Vec BboxSize() const;


Standard_EXPORT   void SetBboxCenter(const gp_Vec& aBboxCenter) ;


Standard_EXPORT   gp_Vec BboxCenter() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString myName;
gp_Vec myBboxSize;
gp_Vec myBboxCenter;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
