// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _V3d_View_HeaderFile
#define _V3d_View_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif

#ifndef _V3d_TypeOfView_HeaderFile
#include <V3d_TypeOfView.hxx>
#endif
#ifndef _V3d_ViewerPointer_HeaderFile
#include <V3d_ViewerPointer.hxx>
#endif
#ifndef _V3d_ListOfTransient_HeaderFile
#include <V3d_ListOfTransient.hxx>
#endif
#ifndef _Handle_Visual3d_View_HeaderFile
#include <Handle_Visual3d_View.hxx>
#endif
#ifndef _Visual3d_ViewMapping_HeaderFile
#include <Visual3d_ViewMapping.hxx>
#endif
#ifndef _Visual3d_ViewOrientation_HeaderFile
#include <Visual3d_ViewOrientation.hxx>
#endif
#ifndef _Visual3d_ContextView_HeaderFile
#include <Visual3d_ContextView.hxx>
#endif
#ifndef _Aspect_Background_HeaderFile
#include <Aspect_Background.hxx>
#endif
#ifndef _Graphic3d_Vector_HeaderFile
#include <Graphic3d_Vector.hxx>
#endif
#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Handle_Aspect_Window_HeaderFile
#include <Handle_Aspect_Window.hxx>
#endif
#ifndef _Handle_Graphic3d_Plotter_HeaderFile
#include <Handle_Graphic3d_Plotter.hxx>
#endif
#ifndef _TColStd_ListIteratorOfListOfTransient_HeaderFile
#include <TColStd_ListIteratorOfListOfTransient.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Aspect_Grid_HeaderFile
#include <Handle_Aspect_Grid.hxx>
#endif
#ifndef _gp_Ax3_HeaderFile
#include <gp_Ax3.hxx>
#endif
#ifndef _Handle_V3d_ColorScale_HeaderFile
#include <Handle_V3d_ColorScale.hxx>
#endif
#ifndef _TColStd_Array2OfReal_HeaderFile
#include <TColStd_Array2OfReal.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
#ifndef _Handle_Graphic3d_Group_HeaderFile
#include <Handle_Graphic3d_Group.hxx>
#endif
#ifndef _V3d_TypeOfProjectionModel_HeaderFile
#include <V3d_TypeOfProjectionModel.hxx>
#endif
#ifndef _Viewer_View_HeaderFile
#include <Viewer_View.hxx>
#endif
#ifndef _V3d_Viewer_HeaderFile
#include <V3d_Viewer.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _Handle_V3d_Viewer_HeaderFile
#include <Handle_V3d_Viewer.hxx>
#endif
#ifndef _Aspect_RenderingContext_HeaderFile
#include <Aspect_RenderingContext.hxx>
#endif
#ifndef _Aspect_GraphicCallbackProc_HeaderFile
#include <Aspect_GraphicCallbackProc.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Quantity_TypeOfColor_HeaderFile
#include <Quantity_TypeOfColor.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Aspect_FillMethod_HeaderFile
#include <Aspect_FillMethod.hxx>
#endif
#ifndef _V3d_Coordinate_HeaderFile
#include <V3d_Coordinate.hxx>
#endif
#ifndef _V3d_TypeOfShadingModel_HeaderFile
#include <V3d_TypeOfShadingModel.hxx>
#endif
#ifndef _V3d_TypeOfSurfaceDetail_HeaderFile
#include <V3d_TypeOfSurfaceDetail.hxx>
#endif
#ifndef _Handle_Graphic3d_TextureEnv_HeaderFile
#include <Handle_Graphic3d_TextureEnv.hxx>
#endif
#ifndef _V3d_TypeOfVisualization_HeaderFile
#include <V3d_TypeOfVisualization.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _V3d_TypeOfZclipping_HeaderFile
#include <V3d_TypeOfZclipping.hxx>
#endif
#ifndef _Handle_V3d_Light_HeaderFile
#include <Handle_V3d_Light.hxx>
#endif
#ifndef _Handle_V3d_Plane_HeaderFile
#include <Handle_V3d_Plane.hxx>
#endif
#ifndef _Aspect_TypeOfTriedronPosition_HeaderFile
#include <Aspect_TypeOfTriedronPosition.hxx>
#endif
#ifndef _Aspect_TypeOfTriedronEcho_HeaderFile
#include <Aspect_TypeOfTriedronEcho.hxx>
#endif
#ifndef _Handle_Aspect_ColorScale_HeaderFile
#include <Handle_Aspect_ColorScale.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _V3d_TypeOfAxe_HeaderFile
#include <V3d_TypeOfAxe.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif
#ifndef _V3d_TypeOfOrientation_HeaderFile
#include <V3d_TypeOfOrientation.hxx>
#endif
#ifndef _Quantity_Coefficient_HeaderFile
#include <Quantity_Coefficient.hxx>
#endif
#ifndef _Quantity_Ratio_HeaderFile
#include <Quantity_Ratio.hxx>
#endif
#ifndef _Handle_PlotMgt_PlotterDriver_HeaderFile
#include <Handle_PlotMgt_PlotterDriver.hxx>
#endif
#ifndef _Aspect_FormatOfSheetPaper_HeaderFile
#include <Aspect_FormatOfSheetPaper.hxx>
#endif
#ifndef _Aspect_Handle_HeaderFile
#include <Aspect_Handle.hxx>
#endif
#ifndef _Handle_Aspect_PixMap_HeaderFile
#include <Handle_Aspect_PixMap.hxx>
#endif
#ifndef _V3d_TypeOfBackfacingModel_HeaderFile
#include <V3d_TypeOfBackfacingModel.hxx>
#endif
class Visual3d_View;
class Aspect_Window;
class Graphic3d_Plotter;
class Aspect_Grid;
class V3d_ColorScale;
class Graphic3d_Structure;
class Graphic3d_Group;
class Viewer_BadValue;
class Standard_TypeMismatch;
class Standard_MultiplyDefined;
class V3d_UnMapped;
class V3d_Viewer;
class Quantity_Color;
class Graphic3d_TextureEnv;
class V3d_Light;
class V3d_Plane;
class Aspect_ColorScale;
class Graphic3d_Vector;
class TColStd_Array2OfReal;
class Graphic3d_Vertex;
class gp_Ax3;
class PlotMgt_PlotterDriver;
class Aspect_PixMap;


//! Defines the application object VIEW for the <br>
//!          VIEWER application. <br>
//!          The methods of this class allow the editing <br>
//!          and inquiring the parameters linked to the view. <br>
//!          (Projection,Mapping,Zclipping,DepthCueing,AntiAliasing <br>
//!           et Conversions) . <br>
//!  Warning: The default parameters are defined by the class <br>
//!          Viewer (Example : SetDefaultViewSize()). <br>
//!          Certain methods are mouse oriented, and it is <br>
//!          necessary to know the difference between the start and <br>
//!          the continuation of this gesture in putting the method <br>
//!          into operation. <br>
//!          Example : Shifting the eye-view along the screen axes. <br>
class V3d_View : public Viewer_View {

public:
 // Methods PUBLIC
 // 

//! Activates the view in the window specified and Map the <br>
//!          Window to the screen. <br>//!  Warning! raises MultiplyDefined from Standard <br>
//!      if the view is already activated in a window. <br>
//!  Warning: The view is centered and resized to preserve <br>
//!          the height/width ratio of the window. <br>
Standard_EXPORT   void SetWindow(const Handle(Aspect_Window)& IdWin) ;

//! Activates the view in the specified Window <br>
//!	    If <aContext> is not NULL the graphic context is used <br>
//!          to draw something in this view. <br>
//!	    Otherwise an internal graphic context is created. <br>
//!	    If <aDisplayCB> is not NULL then a user display CB is <br>
//!	    call at the end of the OCC graphic traversal and just <br>
//!	    before the swap of buffers. The <aClientData> is pass <br>
//!	    to this call back. <br>//!  Warning! raises MultiplyDefined from Standard <br>
//!      if the view is already activated in a window. <br>
//!  Warning: The view is centered and resized to preserve <br>
//!          the height/width ratio of the window. <br>
Standard_EXPORT   void SetWindow(const Handle(Aspect_Window)& aWindow,const Aspect_RenderingContext& aContext,const Aspect_GraphicCallbackProc& aDisplayCB,const Standard_Address aClientData) ;


Standard_EXPORT   void SetMagnify(const Handle(Aspect_Window)& IdWin,const Handle(V3d_View)& aPreviousView,const Standard_Integer x1,const Standard_Integer y1,const Standard_Integer x2,const Standard_Integer y2) ;

//! Destroys the view. <br>
Standard_EXPORT   void Remove() const;

//! Updates the display of the view. <br>
//!          Must be called to update the view <br>
//!          when the update mode is deferred (WAIT) . <br>
Standard_EXPORT   void Update() const;

//! Redisplays the view even if there has not <br>
//!          been any modification. <br>
//!          Must be called if the view is shown. <br>
//!          (Ex: DeIconification ) . <br>
Standard_EXPORT   void Redraw() const;

//! Redisplays the view area after esxposure. <br>
//! [x,y] define the min xy area position <br>
//! [width,height] the size of the area in pixel unit. <br>
Standard_EXPORT   void Redraw(const Standard_Integer x,const Standard_Integer y,const Standard_Integer width,const Standard_Integer height) const;

//! Must be called when the window supporting the <br>
//!          view changes size. <br>//!      if the view is not mapped on a window. <br>
//!  Warning: The view is centered and resized to preserve <br>
//!          the height/width ratio of the window. <br>
Standard_EXPORT   void MustBeResized() ;

//! Must be called when the window supporting the <br>
//!          view is mapped or unmapped. <br>
Standard_EXPORT   void DoMapping() ;

//! Returns the status of the view regarding <br>
//!          the displayed structures inside <br>
//!          Returns True is The View is empty <br>
Standard_EXPORT   Standard_Boolean IsEmpty() const;

//! Updates the lights of the view. The view is redrawn. <br>
Standard_EXPORT   void UpdateLights() const;

//! Defines the background colour of the view <br>
//!          by supplying : <br>
//!          the colour definition type, <br>
//!          and the three corresponding values. <br>
Standard_EXPORT   void SetBackgroundColor(const Quantity_TypeOfColor Type,const Quantity_Parameter V1,const Quantity_Parameter V2,const Quantity_Parameter V3) ;

//! Defines the background colour of the view <br>
//!          by supplying : <br>
//!          the colour object. <br>
Standard_EXPORT   void SetBackgroundColor(const Quantity_Color& Color) ;

//! Defines the background colour of the view <br>
//!          by supplying : <br>
//!          the colour name in the form Quantity_NOC_xxxx . <br>
Standard_EXPORT   void SetBackgroundColor(const Quantity_NameOfColor Name) ;


Standard_EXPORT   void SetBackgroundImage(const Standard_CString FileName,const Aspect_FillMethod FillStyle = Aspect_FM_CENTERED,const Standard_Boolean update = Standard_False) ;


Standard_EXPORT   void SetBgImageStyle(const Aspect_FillMethod FillStyle,const Standard_Boolean update = Standard_False) ;

//! Definition of an axis from its origin and <br>
//!          its orientation . <br>
//!          This will be the current axis for rotations and movements. <br>//!  Warning! raises BadValue from Viewer if the vector normal is NULL. . <br>
Standard_EXPORT   void SetAxis(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z,const Quantity_Parameter Vx,const Quantity_Parameter Vy,const Quantity_Parameter Vz) ;

//! Defines the shading model for the <br>
//!          visualisation ZBUFFER mode. <br>
//!          Various models are available. <br>
Standard_EXPORT   void SetShadingModel(const V3d_TypeOfShadingModel Model) ;

//! select the kind of rendering for texture mapping <br>
//!          no texture mapping by default <br>
Standard_EXPORT   void SetSurfaceDetail(const V3d_TypeOfSurfaceDetail SurfaceDetail) ;

//! set the environment texture to use <br>
//!          no environment texture by default <br>
Standard_EXPORT   void SetTextureEnv(const Handle(Graphic3d_TextureEnv)& ATexture) ;

//! Defines the visualisation mode in the view. <br>
Standard_EXPORT   void SetVisualization(const V3d_TypeOfVisualization Mode) ;

//! Activates antialiasing in the view. <br>
Standard_EXPORT   void SetAntialiasingOn() ;

//! Desactivates antialiasing in the view. <br>
Standard_EXPORT   void SetAntialiasingOff() ;

//! Defines the depth of the medium clipping plane. <br>
Standard_EXPORT   void SetZClippingDepth(const Quantity_Length Depth) ;

//! Defines the thicknes around the medium clippling plane.   . <br>
Standard_EXPORT   void SetZClippingWidth(const Quantity_Length Width) ;

//! Defines the type of ZClipping. <br>
Standard_EXPORT   void SetZClippingType(const V3d_TypeOfZclipping Type) ;

//! Defines the depth of the medium plane. <br>
Standard_EXPORT   void SetZCueingDepth(const Quantity_Length Depth) ;

//! Defines the thickness around the medium plane. <br>
Standard_EXPORT   void SetZCueingWidth(const Quantity_Length Width) ;

//! Activates ZCueing in the view. <br>
Standard_EXPORT   void SetZCueingOn() ;

//! Desactivates ZCueing in the view. <br>
Standard_EXPORT   void SetZCueingOff() ;

//! Activates MyLight in the view. <br>
Standard_EXPORT   void SetLightOn(const Handle(V3d_Light)& MyLight) ;

//! Activates all the lights defined in this view. <br>
Standard_EXPORT   void SetLightOn() ;

//! Desactivate MyLight in this view. <br>
Standard_EXPORT   void SetLightOff(const Handle(V3d_Light)& MyLight) ;

//! Deactivate all the Lights defined in this view. <br>
Standard_EXPORT   void SetLightOff() ;

//! Returns TRUE when the light is active in this view. <br>
Standard_EXPORT   Standard_Boolean IsActiveLight(const Handle(V3d_Light)& aLight) const;

//! Activate/Deactivate the transparency in this view. <br>
Standard_EXPORT   void SetTransparency(const Standard_Boolean AnActivity = Standard_False) ;

//! Activates the clipping plane in this view. <br>//!      If No More Plane can be activated in MyView . <br>
Standard_EXPORT   void SetPlaneOn(const Handle(V3d_Plane)& MyPlane) ;

//! Activate all the clipping planes defined in <br>
//!          this view. <br>//!      If No More Plane can be activated in MyView . <br>
Standard_EXPORT   void SetPlaneOn() ;

//! Desactivates the clipping plane defined <br>
//!          in this view. <br>
Standard_EXPORT   void SetPlaneOff(const Handle(V3d_Plane)& MyPlane) ;

//! Deactivate all clipping planes defined <br>
//!          in this view. <br>
Standard_EXPORT   void SetPlaneOff() ;

//! Returns TRUE when the plane is active in this view. <br>
Standard_EXPORT   Standard_Boolean IsActivePlane(const Handle(V3d_Plane)& aPlane) const;

//! Customization of the ZBUFFER Triedron. <br>
//!         XColor,YColor,ZColor - colors of axis <br>
//!         SizeRatio - ratio of decreasing of the trihedron size when its phisical <br>
//!                     position comes out of the view <br>
//!         AxisDiametr - diameter relatively to axis length <br>
//!         NbFacettes - number of facettes of cylinders and cones <br>
Standard_EXPORT   void ZBufferTriedronSetup(const Quantity_NameOfColor XColor = Quantity_NOC_RED,const Quantity_NameOfColor YColor = Quantity_NOC_GREEN,const Quantity_NameOfColor ZColor = Quantity_NOC_BLUE1,const Standard_Real SizeRatio = 0.8,const Standard_Real AxisDiametr = 0.05,const Standard_Integer NbFacettes = 12) ;

//! Display of the Triedron. <br>
//!         Initialize position, color and length of Triedron axes. <br>
//!         The scale is a percent of the window width. <br>
Standard_EXPORT   void TriedronDisplay(const Aspect_TypeOfTriedronPosition APosition = Aspect_TOTP_CENTER,const Quantity_NameOfColor AColor = Quantity_NOC_WHITE,const Standard_Real AScale = 0.02,const V3d_TypeOfVisualization AMode = V3d_WIREFRAME) ;

//! Erases the Triedron. <br>
Standard_EXPORT   void TriedronErase() ;

//! Highlights the echo zone of the Triedron. <br>
Standard_EXPORT   void TriedronEcho(const Aspect_TypeOfTriedronEcho AType = Aspect_TOTE_NONE) ;


Standard_EXPORT   void ColorScaleDisplay() ;


Standard_EXPORT   void ColorScaleErase() ;


Standard_EXPORT   Standard_Boolean ColorScaleIsDisplayed() const;


Standard_EXPORT   Handle_Aspect_ColorScale ColorScale() const;

//! modify the Projection of the view perpendicularly to <br>
//!          the privileged plane of the viewer. <br>
Standard_EXPORT   void SetFront() ;

//! Rotates the eye about the coordinate system of <br>
//!          reference of the screen <br>
//!          for which the origin is the view point of the projection, <br>
//!          with a relative angular value in RADIANS with respect to <br>
//!          the initial position expressed by Start = Standard_True <br>//!  Warning! raises BadValue from Viewer <br>
//!      If the eye, the view point, or the high point are <br>
//!          aligned or confused. <br>
Standard_EXPORT   void Rotate(const Quantity_PlaneAngle Ax,const Quantity_PlaneAngle Ay,const Quantity_PlaneAngle Az,const Standard_Boolean Start = Standard_True) ;

//! Rotates the eye about the coordinate system of <br>
//!          reference of the screen <br>
//!          for which the origin is Gravity point {X,Y,Z}, <br>
//!          with a relative angular value in RADIANS with respect to <br>
//!          the initial position expressed by Start = Standard_True <br>//!      If the eye, the view point, or the high point are <br>
//!          aligned or confused. <br>
Standard_EXPORT   void Rotate(const Quantity_PlaneAngle Ax,const Quantity_PlaneAngle Ay,const Quantity_PlaneAngle Az,const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z,const Standard_Boolean Start = Standard_True) ;

//! Rotates the eye about one of the coordinate axes of <br>
//!          of the view for which the origin is the Gravity point{X,Y,Z} <br>
//!          with an relative angular value in RADIANS with <br>
//!          respect to the initial position expressed by <br>
//!          Start = Standard_True <br>
Standard_EXPORT   void Rotate(const V3d_TypeOfAxe Axe,const Quantity_PlaneAngle Angle,const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z,const Standard_Boolean Start = Standard_True) ;

//! Rotates the eye about one of the coordinate axes of <br>
//!          of the view for which the origin is the view point of the <br>
//!          projection with an relative angular value in RADIANS with <br>
//!          respect to the initial position expressed by <br>
//!          Start = Standard_True <br>
Standard_EXPORT   void Rotate(const V3d_TypeOfAxe Axe,const Quantity_PlaneAngle Angle,const Standard_Boolean Start = Standard_True) ;

//! Rotates the eye around the current axis a relative <br>
//!          angular value in RADIANS with respect to the initial <br>
//!          position expressed by Start = Standard_True <br>
Standard_EXPORT   void Rotate(const Quantity_PlaneAngle Angle,const Standard_Boolean Start = Standard_True) ;

//! Movement of the eye parallel to the coordinate system <br>
//!          of reference of the screen a distance relative to the <br>
//!          initial position expressed by Start = Standard_True. <br>
Standard_EXPORT   void Move(const Quantity_Length Dx,const Quantity_Length Dy,const Quantity_Length Dz,const Standard_Boolean Start = Standard_True) ;

//! Movement of the eye parallel to one of the axes of the <br>
//!          coordinate system of reference of the view a distance <br>
//!          relative to the initial position expressed by <br>
//!          Start = Standard_True. <br>
Standard_EXPORT   void Move(const V3d_TypeOfAxe Axe,const Quantity_Length Length,const Standard_Boolean Start = Standard_True) ;

//! Movement of the eye parllel to the current axis <br>
//!          a distance relative to the initial position <br>
//!          expressed by Start = Standard_True <br>
Standard_EXPORT   void Move(const Quantity_Length Length,const Standard_Boolean Start = Standard_True) ;

//! Movement of the ye and the view point parallel to the <br>
//!          frame of reference of the screen a distance relative <br>
//!          to the initial position expressed by <br>
//!          Start = Standard_True <br>
Standard_EXPORT   void Translate(const Quantity_Length Dx,const Quantity_Length Dy,const Quantity_Length Dz,const Standard_Boolean Start = Standard_True) ;

//! Movement of the eye and the view point parallel to one <br>
//!          of the axes of the fame of reference of the view a <br>
//!          distance relative to the initial position <br>
//!          expressed by Start = Standard_True <br>
Standard_EXPORT   void Translate(const V3d_TypeOfAxe Axe,const Quantity_Length Length,const Standard_Boolean Start = Standard_True) ;

//! Movement of the eye and view point parallel to <br>
//!          the current axis a distance relative to the initial <br>
//!          position expressed by Start = Standard_True <br>
Standard_EXPORT   void Translate(const Quantity_Length Length,const Standard_Boolean Start = Standard_True) ;

//! places the point of the view corresponding <br>
//!          at the pixel position x,y at the center of the window <br>
//!          and updates the view. <br>
Standard_EXPORT   void Place(const Standard_Integer x,const Standard_Integer y,const Quantity_Factor aZoomFactor = 1) ;

//! Rotation of the view point around the frame of reference <br>
//!          of the screen for which the origin is the eye of the <br>
//!          projection with a relative angular value in RADIANS <br>
//!          with respect to the initial position expressed by <br>
//!          Start = Standard_True <br>
Standard_EXPORT   void Turn(const Quantity_PlaneAngle Ax,const Quantity_PlaneAngle Ay,const Quantity_PlaneAngle Az,const Standard_Boolean Start = Standard_True) ;

//! Rotation of the view point around one of the axes of the <br>
//!          frame of reference of the view for which the origin is <br>
//!          the eye of the projection with an angular value in <br>
//!          RADIANS relative to the initial position expressed by <br>
//!          Start = Standard_True <br>
Standard_EXPORT   void Turn(const V3d_TypeOfAxe Axe,const Quantity_PlaneAngle Angle,const Standard_Boolean Start = Standard_True) ;

//! Rotation of the view point around the current axis an <br>
//!          angular value in RADIANS relative to the initial <br>
//!          position expressed by Start = Standard_True <br>
Standard_EXPORT   void Turn(const Quantity_PlaneAngle Angle,const Standard_Boolean Start = Standard_True) ;

//! Defines the angular position of the high point of <br>
//!          the reference frame of the view with respect to the <br>
//!          Y screen axis with an absolute angular value in <br>
//!          RADIANS. <br>
Standard_EXPORT   void SetTwist(const Quantity_PlaneAngle Angle) ;

//! Defines the position of the eye.. <br>
Standard_EXPORT   void SetEye(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z) ;

//! Defines the Depth of the eye from the view point <br>
//!          without update the projection . <br>
Standard_EXPORT   void SetDepth(const Quantity_Length Depth) ;

//! Defines the orientation of the projection. <br>
Standard_EXPORT   void SetProj(const Quantity_Parameter Vx,const Quantity_Parameter Vy,const Quantity_Parameter Vz) ;

//! Defines the orientation of the projection . <br>
Standard_EXPORT   void SetProj(const V3d_TypeOfOrientation Orientation) ;

//! Defines the position of the view point. <br>
Standard_EXPORT   void SetAt(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z) ;

//! Defines the orientation of the high point. <br>
Standard_EXPORT   void SetUp(const Quantity_Parameter Vx,const Quantity_Parameter Vy,const Quantity_Parameter Vz) ;

//! Defines the orientation(SO) of the high point. <br>
Standard_EXPORT   void SetUp(const V3d_TypeOfOrientation Orientation) ;

//! Saves the current state of the orientation of the view <br>
//!          which will be the return state at ResetViewOrientation. <br>
Standard_EXPORT   void SetViewOrientationDefault() ;

//! Resets the orientation of the view. <br>
//!          Updates the view <br>
Standard_EXPORT   void ResetViewOrientation() ;

//!       translates the center of the view and zooms the view. <br>
//!       Updates the view. <br>
Standard_EXPORT   void Panning(const Quantity_Length Dx,const Quantity_Length Dy,const Quantity_Factor aZoomFactor = 1,const Standard_Boolean Start = Standard_True) ;

//! Defines the centre of the view. <br>
//!          Updates the view. <br>
Standard_EXPORT   void SetCenter(const V3d_Coordinate Xc,const V3d_Coordinate Yc) ;

//! Defines the centre of the view from a pixel position. <br>
//!          Updates the view. <br>
Standard_EXPORT   void SetCenter(const Standard_Integer X,const Standard_Integer Y) ;

//! Defines the size of the view while preserving the <br>
//!          center and height/width ratio of the window supporting <br>
//!          the view. <br>
//!          NOTE than the Depth of the View is NOT modified . <br>
Standard_EXPORT   void SetSize(const Quantity_Length Size) ;

//! Defines the Depth size of the view <br>
//!          Front Plane will be set to Size/2. <br>
//!          Back  Plane will be set to -Size/2. <br>
//!          Any Object located Above the Front Plane or <br>
//!                             behind the Back Plane will be Clipped . <br>
//!          NOTE than the XY Size of the View is NOT modified . <br>
Standard_EXPORT   void SetZSize(const Quantity_Length Size) ;

//! Zooms the view by a factor relative to the initial <br>
//!          value expressed by Start = Standard_True <br>
//!          Updates the view. <br>
Standard_EXPORT   void SetZoom(const Quantity_Factor Coef,const Standard_Boolean Start = Standard_True) ;

//! Zooms the view by a factor relative to the value <br>
//!          initialised by SetViewMappingDefault(). <br>
//!          Updates the view. <br>
Standard_EXPORT   void SetScale(const Quantity_Factor Coef) ;

//! Sets  anisotropic (axial)  scale  factors  <Sx>, <Sy>, <Sz>  for  view <me>. <br>
//! Anisotropic  scaling  operation  is  performed  through  multiplying <br>
//! the current view  orientation  matrix  by  a  scaling  matrix: <br>
//! || Sx  0   0   0 || <br>
//! || 0   Sy  0   0 || <br>
//! || 0   0   Sz  0 || <br>
//! || 0   0   0   1 || <br>
//! Updates the view. <br>
Standard_EXPORT   void SetAxialScale(const Standard_Real Sx,const Standard_Real Sy,const Standard_Real Sz) ;

//! Automatic zoom/panning. Objects in the view are visualised <br>
//!          so as to occupy the maximum space while respecting the <br>
//!          margin coefficient and the initial height /width ratio. <br>
//!          NOTE than the original Z size of the view is NOT modified . <br>
Standard_EXPORT   void FitAll(const Quantity_Coefficient Coef = 0.01,const Standard_Boolean FitZ = Standard_False,const Standard_Boolean update = Standard_True) ;

//! Automatic Depth Panning. Objects visible in the view are <br>
//!          visualised so as to occupy the maximum Z amount of space <br>
//!          while respecting the margin coefficient . <br>
//!          NOTE than the original XY size of the view is NOT modified . <br>
Standard_EXPORT   void ZFitAll(const Quantity_Coefficient Coef = 1.0) ;

//! Centres the defined projection window so that it occupies <br>
//!          the maximum space while respecting the initial <br>
//!          height/width ratio. <br>
//!          NOTE than the original Z size of the view is NOT modified . <br>
Standard_EXPORT   void FitAll(const V3d_Coordinate Umin,const V3d_Coordinate Vmin,const V3d_Coordinate Umax,const V3d_Coordinate Vmax) ;

//! Centres the defined PIXEL window so that it occupies <br>
//!          the maximum space while respecting the initial <br>
//!          height/width ratio. <br>
//!          NOTE than the original Z size of the view is NOT modified . <br>
Standard_EXPORT   void WindowFit(const Standard_Integer Xmin,const Standard_Integer Ymin,const Standard_Integer Xmax,const Standard_Integer Ymax) ;

//! Saves the current view mapping. This will be the <br>
//!          state returned from ResetViewmapping. <br>
Standard_EXPORT   void SetViewMappingDefault() ;

//! Resets the centring of the view. <br>
//!          Updates the view <br>
Standard_EXPORT   void ResetViewMapping() ;

//! Resets the centring and the orientation of the view <br>
//!          Updates the view <br>
Standard_EXPORT   void Reset(const Standard_Boolean update = Standard_True) ;

//! Converts the PIXEL value <br>
//!           to a value in the projection plane. <br>
Standard_EXPORT   Quantity_Length Convert(const Standard_Integer Vp) const;

//! Converts the point PIXEL into a point projected <br>
//!           in the reference frame of the projection plane. <br>
Standard_EXPORT   void Convert(const Standard_Integer Xp,const Standard_Integer Yp,V3d_Coordinate& Xv,V3d_Coordinate& Yv) const;

//! Converts tha value of the projection plane into <br>
//!           a PIXEL value. <br>
Standard_EXPORT   Standard_Integer Convert(const Quantity_Length Vv) const;

//! Converts the point defined in the reference frame <br>
//!           of the projection plane into a point PIXEL. <br>
Standard_EXPORT   void Convert(const V3d_Coordinate Xv,const V3d_Coordinate Yv,Standard_Integer& Xp,Standard_Integer& Yp) const;

//! Converts the projected point into a point <br>
//!           in the reference frame of the view corresponding <br>
//!           to the intersection with the projection plane <br>
//!           of the eye/view point vector. <br>
Standard_EXPORT   void Convert(const Standard_Integer Xp,const Standard_Integer Yp,V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Converts the projected point into the nearest grid point <br>
//!           in the reference frame of the view corresponding <br>
//!           to the intersection with the projection plane <br>
//!           of the eye/view point vector and display the grid marker. <br>
//!  Warning: When the grid is not active the result is identical <br>
//!	   to the above Convert() method. <br>
//! How to use : <br>
//! 1) Enable the grid echo display <br>
//!    myViewer->SetGridEcho(Standard_True); <br>
//! 2) When application receive a move event : <br>
//!   2.1) Check if any object is detected <br>
//!     if( myInteractiveContext->MoveTo(x,y) == AIS_SOD_Nothing ) { <br>
//!   2.2) Check if the grid is active <br>
//!     if( myViewer->Grid()->IsActive() ) { <br>
//!   2.3) Display the grid echo and gets the grid point <br>
//!       myView->ConvertToGrid(x,y,X,Y,Z); <br>
//!   2.4) Else this is the standard case <br>
//!     } else myView->Convert(x,y,X,Y,Z); <br>
Standard_EXPORT   void ConvertToGrid(const Standard_Integer Xp,const Standard_Integer Yp,V3d_Coordinate& Xg,V3d_Coordinate& Yg,V3d_Coordinate& Zg) const;

//! Converts the point into the nearest grid point <br>
//!           and display the grid marker. <br>
Standard_EXPORT   void ConvertToGrid(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z,V3d_Coordinate& Xg,V3d_Coordinate& Yg,V3d_Coordinate& Zg) const;

//! Projects the point defined in the reference frame of <br>
//!           the view into the projected point in the associated window. <br>
Standard_EXPORT   void Convert(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z,Standard_Integer& Xp,Standard_Integer& Yp) const;

//! Converts the point defined in the user space of <br>
//!           the view to the projected view plane point at z 0. <br>
Standard_EXPORT   void Project(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z,V3d_Coordinate& Xp,V3d_Coordinate& Yp) const;

//! Returns the Background color values of the view <br>
//!          depending of the color Type. <br>
Standard_EXPORT   void BackgroundColor(const Quantity_TypeOfColor Type,Quantity_Parameter& V1,Quantity_Parameter& V2,Quantity_Parameter& V3) const;

//! Returns the Background color object of the view. <br>
Standard_EXPORT   Quantity_Color BackgroundColor() const;

//! Returns the current value of the zoom expressed with <br>
//!          respect to SetViewMappingDefault(). <br>
Standard_EXPORT   Quantity_Factor Scale() const;

//! Returns the current values of the anisotropic (axial) scale factors. <br>
Standard_EXPORT   void AxialScale(Standard_Real& Sx,Standard_Real& Sy,Standard_Real& Sz) const;

//! Returns the centre of the view. <br>
Standard_EXPORT   void Center(V3d_Coordinate& Xc,V3d_Coordinate& Yc) const;

//! Returns the height and width of the view. <br>
Standard_EXPORT   void Size(Quantity_Length& Width,Quantity_Length& Height) const;

//! Returns the Depth of the view . <br>
Standard_EXPORT   Standard_Real ZSize() const;

//! Returns the position of the eye. <br>
Standard_EXPORT   void Eye(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Returns the position of point which emanating the <br>
//!          projections. <br>
Standard_EXPORT   void FocalReferencePoint(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Returns the coordinate of the point (Xpix,Ypix) <br>
//!          in the view (XP,YP,ZP), and the projection vector of the <br>
//!          view passing by the point (for PerspectiveView). <br>
Standard_EXPORT   void ProjReferenceAxe(const Standard_Integer Xpix,const Standard_Integer Ypix,V3d_Coordinate& XP,V3d_Coordinate& YP,V3d_Coordinate& ZP,V3d_Coordinate& VX,V3d_Coordinate& VY,V3d_Coordinate& VZ) const;

//! Returns the Distance between the Eye and View Point. <br>
Standard_EXPORT   Quantity_Length Depth() const;

//! Returns the projection vector. <br>
Standard_EXPORT   void Proj(Quantity_Parameter& Vx,Quantity_Parameter& Vy,Quantity_Parameter& Vz) const;

//! Returns the position of the view point. <br>
Standard_EXPORT   void At(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Returns the vector giving the position of the high point. <br>
Standard_EXPORT   void Up(Quantity_Parameter& Vx,Quantity_Parameter& Vy,Quantity_Parameter& Vz) const;

//! Returns in RADIANS the orientation of the view around <br>
//!          the visual axis measured from the Y axis of the screen. <br>
Standard_EXPORT   Quantity_PlaneAngle Twist() const;

//! Returns the current shading model. <br>
Standard_EXPORT   V3d_TypeOfShadingModel ShadingModel() const;


Standard_EXPORT   V3d_TypeOfSurfaceDetail SurfaceDetail() const;


Standard_EXPORT   Handle_Graphic3d_TextureEnv TextureEnv() const;

//! Returns the transparency activity. <br>
Standard_EXPORT   Standard_Boolean Transparency() const;

//! Returns the current visualisation mode. <br>
Standard_EXPORT   V3d_TypeOfVisualization Visualization() const;

//! Indicates if the antialiasing is active (True) or <br>
//!          inactive (False). <br>
Standard_EXPORT   Standard_Boolean Antialiasing() const;

//! Returns activity and information on the Zcueing. <br>
//!          <Depth> : Depth of plane. <br>
//!          <Width> : Thickness around the plane. <br>
Standard_EXPORT   Standard_Boolean ZCueing(Quantity_Length& Depth,Quantity_Length& Width) const;

//! Returns current information on the ZClipping. <br>
//!          <Depth> : Depth of plane. <br>
//!          <Width> : Thickness around the plane. <br>
//!          <TypeOfZclipping>  :        "BACK" <br>
//!                                      "FRONT" <br>
//!                                      "SLICE" <br>
//!                                      "OFF" <br>
Standard_EXPORT   V3d_TypeOfZclipping ZClipping(Quantity_Length& Depth,Quantity_Length& Width) const;

//! Returns True if One light more can be <br>
//!          activated in this View. <br>
Standard_EXPORT   Standard_Boolean IfMoreLights() const;

//! initializes an iteration on the active Lights. <br>
Standard_EXPORT   void InitActiveLights() ;

//! returns true if there are more active Light(s) to return. <br>
Standard_EXPORT   Standard_Boolean MoreActiveLights() const;

//! Go to the next active Light <br>
//!           (if there is not, ActiveLight will raise an exception) <br>
Standard_EXPORT   void NextActiveLights() ;


Standard_EXPORT   Handle_V3d_Light ActiveLight() const;

//! Returns True if One clipping plane more can be <br>
//!          activated in this View. <br>
Standard_EXPORT   Standard_Boolean IfMorePlanes() const;

//! initializes an iteration on the active Planes. <br>
Standard_EXPORT   void InitActivePlanes() ;

//! returns true if there are more active Plane(s) to return. <br>
Standard_EXPORT   Standard_Boolean MoreActivePlanes() const;

//! Go to the next active Plane <br>
//!           (if there is not, ActivePlane will raise an exception) <br>
Standard_EXPORT   void NextActivePlanes() ;


Standard_EXPORT   Handle_V3d_Plane ActivePlane() const;

//! Returns the viewer in which the view has been created. <br>
Standard_EXPORT   Handle_V3d_Viewer Viewer() const;

//! Returns True if MyView is associated with a window . <br>
Standard_EXPORT   Standard_Boolean IfWindow() const;

//! Returns the Aspect Window associated with the view. <br>
Standard_EXPORT   Handle_Aspect_Window Window() const;

//! Returns the Type of the View <br>
Standard_EXPORT   V3d_TypeOfView Type() const;

//! translates the center of the view and zooms the view. <br>
//!       and updates the view. <br>
Standard_EXPORT   void Pan(const Standard_Integer Dx,const Standard_Integer Dy,const Quantity_Factor aZoomFactor = 1) ;

//! Zoom the view according to a zoom factor computed <br>
//! from the distance between the 2 mouse position <X1,Y1>,<X2,Y2> <br>
Standard_EXPORT   void Zoom(const Standard_Integer X1,const Standard_Integer Y1,const Standard_Integer X2,const Standard_Integer Y2) ;

//! Zoom the view according to a zoom factor computed <br>
//! from the distance between the last and new mouse position <X,Y> <br>
Standard_EXPORT   void Zoom(const Standard_Integer X,const Standard_Integer Y) ;

//! Performs  anisotropic scaling  of  <me>  view  along  the  given  <Axis>. <br>
//! The  scale  factor  is  calculated on a basis of <br>
//! the mouse pointer displacement <Dx,Dy>. <br>
//! The  calculated  scale  factor  is  then  passed  to  SetAxialScale(Sx,  Sy,  Sz)  method. <br>
Standard_EXPORT   void AxialScale(const Standard_Integer Dx,const Standard_Integer Dy,const V3d_TypeOfAxe Axis) ;

//! Begin the rotation of the view arround the screen axis <br>
//! according to the mouse position <X,Y>. <br>
//!  Warning: Enable rotation around the Z screen axis when <zRotationThreshold> <br>
//! factor is > 0 soon the distance from the start point and the center <br>
//! of the view is > (medium viewSize * <zRotationThreshold> ). <br>
//! Generally a value of 0.4 is usable to rotate around XY screen axis <br>
//! inside the circular treshold area and to rotate around Z screen axis <br>
//! outside this area. <br>
Standard_EXPORT   void StartRotation(const Standard_Integer X,const Standard_Integer Y,const Quantity_Ratio zRotationThreshold = 0.0) ;

//! Continues the rotation of the view <br>
//! with an angle computed from the last and new mouse position <X,Y>. <br>
Standard_EXPORT   void Rotation(const Standard_Integer X,const Standard_Integer Y) ;

//! Change View Plane Distance for Perspective Views <br>//!  Warning! raises TypeMismatch from Standard if the view <br>
//!          is not a perspective view. <br>
Standard_EXPORT   void SetFocale(const Quantity_Length Focale) ;

//! Returns the View Plane Distance for Perspective Views <br>
Standard_EXPORT   Quantity_Length Focale() const;

//! Returns the associated Visual3d view. <br>
Standard_EXPORT   Handle_Visual3d_View View() const;

//! Begins any graphics in the view <aView> <br>
//!          Redraw any structured graphics in the back buffer before <br>
//!          if <DoubleBuffer> is TRUE. <br>
//!          Restore the front buffer from the back before <br>
//!          if <DoubleBuffer> is FALSE. <br>
//!          if <RetainMode> is TRUE. <br>
//!          the graphic managed itself exposure,resizing ... <br>
//!          if <RetainMode> is FALSE. <br>
//!          the application must managed itself exposure,resizing ... <br>
//! <br>
Standard_EXPORT   Standard_Boolean TransientManagerBeginDraw(const Standard_Boolean DoubleBuffer = Standard_False,const Standard_Boolean RetainMode = Standard_False) const;

//! Clear all transient graphics in the view <aView> <br>
Standard_EXPORT   void TransientManagerClearDraw() const;

//! Begins any add graphics in the view <aView> <br>
//!          Redraw any structured graphics in the back buffer before <br>
//!          the application must managed itself exposure,resizing ... <br>
//!  Warning: Returns TRUE if transient drawing is enabled in <br>
//!         the associated view. <br>
//!          Returns FALSE ,if nothing works because something <br>
//!         is wrong for the transient principle : <br>
//! <br>
Standard_EXPORT   Standard_Boolean TransientManagerBeginAddDraw() const;

//! Activates animation mode. <br>
//!      When the animation mode is activated in the view, <br>
//!      all Graphic3d_Structure are stored in a graphic object. <br>
Standard_EXPORT   void SetAnimationModeOn() ;

//! Deactivates the animation mode. <br>
Standard_EXPORT   void SetAnimationModeOff() ;

//! Returns the activity of the animation mode. <br>
Standard_EXPORT   Standard_Boolean AnimationModeIsOn() const;

//! Enable/Disable animation/degeneration mode <br>
Standard_EXPORT   void SetAnimationMode(const Standard_Boolean anAnimationFlag = Standard_True,const Standard_Boolean aDegenerationFlag = Standard_False) ;

//! Returns the animation and degenerate status. <br>
Standard_EXPORT   Standard_Boolean AnimationMode(Standard_Boolean& isDegenerate) const;

//! Activates degenerate mode. <br>
//!      When the degenerate mode is activated in the view, <br>
//!      all Graphic3d_Structure with the type TOS_COMPUTED <br>
//!      displayed in this view are not computed. <br>
//!  Warning: Obsolete method , use SetComputedMode() <br>
Standard_EXPORT   void SetDegenerateModeOn() ;

//! Deactivates the degenerate mode. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: if the computed mode has been disabled in the <br>
//!          viewer the mode will remain degenerated. <br>
//!  Warning: Obsolete method , use SetComputedMode() <br>
Standard_EXPORT   void SetDegenerateModeOff() ;

//! Returns the activity of the degenerate mode. <br>
Standard_EXPORT   Standard_Boolean DegenerateModeIsOn() const;

//! Switches computed HLR mode in the view <br>
Standard_EXPORT   void SetComputedMode(const Standard_Boolean aMode) ;

//! Returns the computed HLR mode state <br>
Standard_EXPORT   Standard_Boolean ComputedMode() const;

//! idem than WindowFit <br>
Standard_EXPORT   void WindowFitAll(const Standard_Integer Xmin,const Standard_Integer Ymin,const Standard_Integer Xmax,const Standard_Integer Ymax) ;

//! Set a plotter for plotting the contents of the view <br>
//!          field MyPlotter <br>
Standard_EXPORT virtual  void SetPlotter(const Handle(Graphic3d_Plotter)& aPlotter) ;

//! Create a 2D View for plotting the contents of the view <br>
Standard_EXPORT   void Plot() ;

//! Defines or Updates the definition of the <br>
//!          grid in <me> <br>
Standard_EXPORT   void SetGrid(const gp_Ax3& aPlane,const Handle(Aspect_Grid)& aGrid) ;

//! Defines or Updates the graphic definition of the <br>
//!          grid in <me> <br>
Standard_EXPORT   void SetGridGraphicValues(const Handle(Aspect_Grid)& aGrid) ;

//! Defines or Updates the activity of the <br>
//!          grid in <me> <br>
Standard_EXPORT   void SetGridActivity(const Standard_Boolean aFlag) ;

//! Animates the view <me> <br>
//!          Returns the number of images per second <br>
//!          if <AnimationMode> is Standard_True, the animation mode <br>
//!          is activated. <br>
Standard_EXPORT   Standard_Real Tumble(const Standard_Integer NbImages = 314,const Standard_Boolean AnimationMode = Standard_False) ;

//! dump the view <br>
Standard_EXPORT   void ScreenCopy(const Handle(PlotMgt_PlotterDriver)& aPlotterDriver,const Standard_Boolean fWhiteBackground = Standard_True,const Quantity_Factor aScale = 1.0) ;

//! dump the  full contents  of the  view at  the same <br>
//!          scale    in the file   <aFile>.    The  file name <br>
//!          extension must be one of <br>
//!	    ".xwd",".gif",".bmp" both on UNIX or WNT. <br>
//!          and returns FALSE when the dump has failed <br>
Standard_EXPORT   Standard_Boolean Dump(const Standard_CString aFile) ;

//! dump the full contents of the view with a <br>
//!          different scale according  to the required sheet <br>
//!          paper   size  (format)  and  the    ratio <br>
//!          width/height of the view. <br>
//!          and returns FALSE when the dump has failed <br>
//!  Warning : the file name extension must be one of <br>
//!		".xwd",".gif",".bmp" both on UNIX or WNT <br>
//!	     but make becarefull about the time to dump and <br>
//!	     resulting file size especially for the A0 format, <br>
//!	     GIF format generates very small <br>
//!	     files, BMP and XWD generates big files <br>
//!	     (4 to 6 times more than GIF). <br>
//!	     Time to generates the files is very short with XWD <br>
//!	     files and 2 or 4 times more for other format. <br>
//!	     NOTE that you can use after any standard system utility <br>
//!	     for editing or sending the image file to a laser printer. <br>
//!	     (i.e: Microsoft Photo Editor on Windows system <br>
//!	      or Image Viewer on SUN system) <br>
Standard_EXPORT   Standard_Boolean Dump(const Standard_CString aFile,const Aspect_FormatOfSheetPaper aFormat) ;

//! print the contents of the view to printer with preview. <br>
//! <hPrnDC> : If you have already an PrinterDeviceContext (HDC), <br>
//! then you can pass it to the print routines. <br>
//! If you don't have an PrinterDeviceContext, then this parameter should <br>
//! be NULL. <br>
//! <showDialog> : If hPrnDC == NULL, then you can force the print routines to <br>
//! open a Print Dialog box. <br>
//! If you want to do this, then set showDialog to TRUE <br>
//! If you don't want to see a dialog (only possible, if you have a hPrnDC <br>
//! or the dialog box was opened once before) then set <showDialog> to FALSE. <br>
//! <showBackground> : When set to FALSE then print the view without background color <br>
//! (background is white) <br>
//! else set to TRUE for printing with current background color. <br>
//! <filename>: If != NULL, then the view will be printed to a file. <br>
//!  Warning: Works only under Windows. <br>
Standard_EXPORT   void Print(const Aspect_Handle& hPrnDC = NULL,const Standard_Boolean showDialog = Standard_True,const Standard_Boolean showBackground = Standard_True,const Standard_CString filename = NULL) const;

//! dump the full contents of the view to a pixmap <br>
//! of pixel size <aWidth>*<aHeight> and planes depth <aCDepth> <br>
Standard_EXPORT   Handle_Aspect_PixMap ToPixMap(const Standard_Integer aWidth,const Standard_Integer aHeight,const Standard_Integer aCDepth = 24) ;

//! Manages projection model <br>
Standard_EXPORT   void SetProjModel(const V3d_TypeOfProjectionModel amOdel = V3d_TPM_SCREEN) ;

//! Returns the current projection model <br>
Standard_EXPORT   V3d_TypeOfProjectionModel ProjModel() const;

//! Manages display of the back faces <br>
//! When <aModel> is TOBM_AUTOMATIC the object backfaces <br>
//!	are displayed only for surface objects and <br>
//!	never displayed for solid objects. <br>
//!	this was the previous mode. <br>
//!      <aModel> is TOBM_ALWAYS_DISPLAYED the object backfaces <br>
//!		  are always displayed both for surfaces or solids. <br>
//!      <aModel> is TOBM_NEVER_DISPLAYED the object backfaces <br>
//!		  are never displayed. <br>
Standard_EXPORT   void SetBackFacingModel(const V3d_TypeOfBackfacingModel aModel = V3d_TOBM_AUTOMATIC) ;

//! Returns current state of the back faces display <br>
Standard_EXPORT   V3d_TypeOfBackfacingModel BackFacingModel() const;

//! turns on/off opengl depth testing <br>
Standard_EXPORT   void EnableDepthTest(const Standard_Boolean enable = Standard_True) const;

//! returns the current state of the depth testing <br>
Standard_EXPORT   Standard_Boolean IsDepthTestEnabled() const;

//! turns on/off opengl lighting, currently used in triedron displaying <br>
Standard_EXPORT   void EnableGLLight(const Standard_Boolean enable = Standard_True) const;

//! returns the current state of the gl lighting <br>
//!          currently used in triedron displaying <br>
Standard_EXPORT   Standard_Boolean IsGLLightEnabled() const;
//Standard_EXPORT ~V3d_View();


friend 
//! Activates all of the views of a viewer attached <br>
//!	    to a window. <br>
Standard_EXPORT   void V3d_Viewer::SetViewOn() ;
friend 
//! Activates a particular view in the Viewer . <br>
//!	    Must be call if the Window attached to the view <br>
//!	    has been Deiconified . <br>
Standard_EXPORT   void V3d_Viewer::SetViewOn(const Handle(V3d_View)& View) ;
friend 
//! Deactivates all the views of a Viewer <br>
//!	    attached to a window. <br>
Standard_EXPORT   void V3d_Viewer::SetViewOff() ;
friend 
//! Deactivates a particular view in the Viewer. <br>
//!	    Must be call if the Window attached to the view <br>
//!	    has been Iconified . <br>
Standard_EXPORT   void V3d_Viewer::SetViewOff(const Handle(V3d_View)& View) ;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Initialises the view. <br>
Standard_EXPORT V3d_View(const Handle(V3d_Viewer)& VM,const V3d_TypeOfView Type = V3d_ORTHOGRAPHIC);

//! Initialises the view by copying. <br>
Standard_EXPORT V3d_View(const Handle(V3d_Viewer)& VM,const Handle(V3d_View)& V,const V3d_TypeOfView Type = V3d_ORTHOGRAPHIC);


 // Fields PROTECTED
 //
V3d_TypeOfView MyType;
Handle_Visual3d_View MyView;
Visual3d_ViewMapping MyViewMapping;
V3d_TypeOfProjectionModel MyProjModel;


private: 

 // Methods PRIVATE
 // 

//! Change the scale factor and position of the view <br>
//! such as the bounding box <Umin, Vmin, Umax, Vmax> is contains <br>
//! in the view. <br>
Standard_EXPORT   void FitAll(const Handle(Aspect_Window)& aWindow,const V3d_Coordinate Umin,const V3d_Coordinate Vmin,const V3d_Coordinate Umax,const V3d_Coordinate Vmax) ;

//! Determines the screen axes in the reference <br>
//!          framework of the view. <br>
Standard_EXPORT static  Standard_Boolean ScreenAxis(const Graphic3d_Vector& Vpn,const Graphic3d_Vector& Vup,Graphic3d_Vector& Xaxe,Graphic3d_Vector& Yaxe,Graphic3d_Vector& Zaxe) ;


Standard_EXPORT static  void InitMatrix(TColStd_Array2OfReal& Matrix) ;


Standard_EXPORT static  Standard_Boolean Multiply(const TColStd_Array2OfReal& Left,const TColStd_Array2OfReal& Right,TColStd_Array2OfReal& Matrix) ;

//! Determines the rotation matrice around an axis <br>
//!          for a given angle. <br>
Standard_EXPORT static  void RotAxis(const Graphic3d_Vertex& Vrp,const Graphic3d_Vector& Axe,const Quantity_PlaneAngle Angle,TColStd_Array2OfReal& Matrix) ;

//! Transforms the point P according to the matrice Matrix . <br>
Standard_EXPORT static  Graphic3d_Vertex TrsPoint(const Graphic3d_Vertex& P,const TColStd_Array2OfReal& Matrix) ;

//! Transforms the vector V according to the matrice Matrix . <br>
Standard_EXPORT static  Graphic3d_Vector TrsPoint(const Graphic3d_Vector& V,const TColStd_Array2OfReal& Matrix) ;

//! Returns the objects number and the projection window <br>
//!          of the objects contained in the view. <br>
Standard_EXPORT   Standard_Integer MinMax(V3d_Coordinate& Umin,V3d_Coordinate& Vmin,V3d_Coordinate& Umax,V3d_Coordinate& Vmax) const;

//! Returns the objects number and the box encompassing <br>
//!          the objects contained in the view <br>
Standard_EXPORT   Standard_Integer MinMax(V3d_Coordinate& Xmin,V3d_Coordinate& Ymin,V3d_Coordinate& Zmin,V3d_Coordinate& Xmax,V3d_Coordinate& Ymax,V3d_Coordinate& Zmax) const;

//! Returns the Objects number and the gravity center <br>
//!          of ALL viewable points in the view <br>
Standard_EXPORT   Standard_Integer Gravity(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;


Standard_EXPORT   void Init() ;

//! Returns a new vertex when the grid is activated. <br>
Standard_EXPORT   Graphic3d_Vertex Compute(const Graphic3d_Vertex& AVertex) const;


 // Fields PRIVATE
 //
V3d_ViewerPointer MyViewer;
V3d_ListOfTransient MyActiveLights;
V3d_ListOfTransient MyActivePlanes;
Visual3d_ViewOrientation MyViewOrientation;
Visual3d_ContextView MyViewContext;
Aspect_Background MyBackground;
Graphic3d_Vector MyDefaultViewAxis;
Graphic3d_Vertex MyDefaultViewPoint;
Handle_Aspect_Window MyWindow;
Handle_Graphic3d_Plotter MyPlotter;
TColStd_ListIteratorOfListOfTransient myActiveLightsIterator;
TColStd_ListIteratorOfListOfTransient myActivePlanesIterator;
Standard_Integer sx;
Standard_Integer sy;
Standard_Real rx;
Standard_Real ry;
Standard_Real gx;
Standard_Real gy;
Standard_Real gz;
Standard_Boolean myComputedMode;
Standard_Boolean SwitchSetFront;
Handle_Aspect_Grid MyGrid;
gp_Ax3 MyPlane;
Handle_V3d_ColorScale MyColorScale;
TColStd_Array2OfReal MyTrsf;
Handle_Graphic3d_Structure MyGridEchoStructure;
Handle_Graphic3d_Group MyGridEchoGroup;
Standard_Integer MyAnimationFlags;
Standard_Boolean MyTransparencyFlag;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
