// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _V3d_DirectionalLight_HeaderFile
#define _V3d_DirectionalLight_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_V3d_DirectionalLight_HeaderFile
#include <Handle_V3d_DirectionalLight.hxx>
#endif

#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _V3d_PositionLight_HeaderFile
#include <V3d_PositionLight.hxx>
#endif
#ifndef _Handle_V3d_Viewer_HeaderFile
#include <Handle_V3d_Viewer.hxx>
#endif
#ifndef _V3d_TypeOfOrientation_HeaderFile
#include <V3d_TypeOfOrientation.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _V3d_Coordinate_HeaderFile
#include <V3d_Coordinate.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _V3d_TypeOfRepresentation_HeaderFile
#include <V3d_TypeOfRepresentation.hxx>
#endif
#ifndef _Handle_Graphic3d_Group_HeaderFile
#include <Handle_Graphic3d_Group.hxx>
#endif
class Viewer_BadValue;
class V3d_Viewer;
class V3d_View;
class Graphic3d_Group;


//! Create and modify a directional light source <br>
//!          in a viewer. <br>
class V3d_DirectionalLight : public V3d_PositionLight {

public:
 // Methods PUBLIC
 // 

//! Creates a directional light source in the viewer. <br>
Standard_EXPORT V3d_DirectionalLight(const Handle(V3d_Viewer)& VM,const V3d_TypeOfOrientation Direction = V3d_XposYposZpos,const Quantity_NameOfColor Color = Quantity_NOC_WHITE,const Standard_Boolean Headlight = Standard_False);

//! Creates a directional light source in the viewer. <br>
//!          Xt,Yt,Zt : Coordinate of light source Target. <br>
//!          Xp,Yp,Zp : Coordinate of light source Position. <br>
//!          The others parameters describe before. <br>
Standard_EXPORT V3d_DirectionalLight(const Handle(V3d_Viewer)& VM,const V3d_Coordinate Xt,const V3d_Coordinate Yt,const V3d_Coordinate Zt,const V3d_Coordinate Xp,const V3d_Coordinate Yp,const V3d_Coordinate Zp,const Quantity_NameOfColor Color = Quantity_NOC_WHITE,const Standard_Boolean Headlight = Standard_False);

//! Defines the direction of the light source <br>
//!	     by a predefined orientation. <br>
Standard_EXPORT   void SetDirection(const V3d_TypeOfOrientation Direction) ;

//! Defines the direction of the light source by the predefined <br>
//! vector Xm,Ym,Zm. <br>
//!  Warning: raises  BadValue from Viewer if the vector is null. <br>
Standard_EXPORT   void SetDirection(const Quantity_Parameter Xm,const Quantity_Parameter Ym,const Quantity_Parameter Zm) ;

//! Defines the point of light source representation. <br>
Standard_EXPORT   void SetDisplayPosition(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z) ;

//! Calls SetDisplayPosition method. <br>
Standard_EXPORT virtual  void SetPosition(const V3d_Coordinate Xp,const V3d_Coordinate Yp,const V3d_Coordinate Zp) ;

//! Display the graphic structure of light source <br>
//!          in the choosen view. We have three type of representation <br>
//!          - SIMPLE   : Only the light source is displayed. <br>
//!          - PARTIAL  : The light source and the light space are <br>
//!                       displayed. <br>
//!          - COMPLETE : The same representation as PARTIAL. <br>
//!          We can choose the "SAMELAST" as parameter of representation <br>
//!          In this case the graphic structure representation will be <br>
//!          the last displayed. <br>
Standard_EXPORT   void Display(const Handle(V3d_View)& aView,const V3d_TypeOfRepresentation Representation) ;

//! Calls DisplayPosition method. <br>
Standard_EXPORT virtual  void Position(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Returns the choosen position to represent the light <br>
//!          source. <br>
Standard_EXPORT   void DisplayPosition(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Returns the Vx,Vy,Vz direction of the light source. <br>
Standard_EXPORT   void Direction(Quantity_Parameter& Vx,Quantity_Parameter& Vy,Quantity_Parameter& Vz) const;
//Standard_EXPORT ~V3d_DirectionalLight();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Defines the representation of the directional light source. <br>
Standard_EXPORT   void Symbol(const Handle(Graphic3d_Group)& gsymbol,const Handle(V3d_View)& aView) const;


 // Fields PRIVATE
 //
Graphic3d_Vertex MyDisplayPosition;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
