// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_Quantity_HeaderFile
#define _Units_Quantity_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Units_Quantity_HeaderFile
#include <Handle_Units_Quantity.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_Units_Dimensions_HeaderFile
#include <Handle_Units_Dimensions.hxx>
#endif
#ifndef _Handle_Units_UnitsSequence_HeaderFile
#include <Handle_Units_UnitsSequence.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TCollection_HAsciiString;
class Units_Dimensions;
class Units_UnitsSequence;


//! This  class stores  in its  field all the possible <br>
//!          units of all the unit systems for a given physical <br>
//!          quantity. Each unit's  value  is  expressed in the <br>
//!          S.I. unit system. <br>
class Units_Quantity : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 
//! Creates  a new Quantity  object with <aname> which  is <br>
//!          the name of the physical quantity, <adimensions> which <br>
//!          is the physical dimensions, and <aunitssequence> which <br>
//!          describes all the units known for this quantity. <br>
Units_Quantity(const Standard_CString aname,const Handle(Units_Dimensions)& adimensions,const Handle(Units_UnitsSequence)& aunitssequence);
//! Returns in a AsciiString from TCollection the name of the quantity. <br>
  TCollection_AsciiString Name() const;
//! Returns the physical dimensions of the quantity. <br>
  Handle_Units_Dimensions Dimensions() const;
//! Returns <theunitssequence>, which  is the  sequence of <br>
//!          all the units stored for this physical quantity. <br>
  Handle_Units_UnitsSequence Sequence() const;

//! Returns True if the name of the Quantity <me> is equal <br>
//!          to <astring>, False otherwise. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const Standard_CString astring) const;
friend Standard_EXPORT Standard_Boolean operator ==(const Handle(Units_Quantity)&,const Standard_CString);

//! Useful for debugging. <br>
Standard_EXPORT   void Dump(const Standard_Integer ashift,const Standard_Integer alevel) const;
//Standard_EXPORT ~Units_Quantity();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString thename;
Handle_Units_Dimensions thedimensions;
Handle_Units_UnitsSequence theunitssequence;


};


#include <Units_Quantity.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
