// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopTools_LocationSet_HeaderFile
#define _TopTools_LocationSet_HeaderFile

#ifndef _TopLoc_IndexedMapOfLocation_HeaderFile
#include <TopLoc_IndexedMapOfLocation.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_IStream_HeaderFile
#include <Standard_IStream.hxx>
#endif
class Standard_OutOfRange;
class TopLoc_Location;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The class LocationSet stores a set of location in <br>
//!          a relocatable state. <br>
//! <br>
//!          It can be created from Locations. <br>
//! <br>
//!          It can create Locations. <br>
//! <br>
//!          It can be write and read from a stream. <br>
class TopTools_LocationSet  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns an empty set of locations. <br>
Standard_EXPORT TopTools_LocationSet();

//! Clears the content of the set. <br>
Standard_EXPORT   void Clear() ;

//! Incorporate a new Location in the  set and returns <br>
//!          its index. <br>
Standard_EXPORT   Standard_Integer Add(const TopLoc_Location& L) ;

//! Returns the location of index <I>. <br>
//! <br>
Standard_EXPORT  const TopLoc_Location& Location(const Standard_Integer I) const;

//! Returns the index of <L>. <br>
Standard_EXPORT   Standard_Integer Index(const TopLoc_Location& L) const;

//! Dumps the content of me on the stream <OS>. <br>
Standard_EXPORT   void Dump(Standard_OStream& OS) const;

//! Writes the content of  me  on the stream <OS> in a <br>
//!          format that can be read back by Read. <br>
Standard_EXPORT   void Write(Standard_OStream& OS) const;

//! Reads the content of me from the  stream  <IS>. me <br>
//!          is first cleared. <br>
//! <br>
Standard_EXPORT   void Read(Standard_IStream& IS) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopLoc_IndexedMapOfLocation myMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
