// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepTool_ShapeExplorer_HeaderFile
#define _TopOpeBRepTool_ShapeExplorer_HeaderFile

#ifndef _TopExp_Explorer_HeaderFile
#include <TopExp_Explorer.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class TopOpeBRepTool_ShapeExplorer  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty explorer, becomes usefull after Init. <br>
Standard_EXPORT TopOpeBRepTool_ShapeExplorer();

//! Creates an Explorer on the Shape <S>. <br>
//! <br>
//!          <ToFind> is the type of shapes to search. <br>
//!              TopAbs_VERTEX, TopAbs_EDGE, ... <br>
//! <br>
//!          <ToAvoid>   is the type   of shape to  skip in the <br>
//!          exploration.   If   <ToAvoid>  is  equal  or  less <br>
//!          complex than <ToFind> or if  <ToAVoid> is SHAPE it <br>
//!          has no effect on the exploration. <br>
//! <br>
Standard_EXPORT TopOpeBRepTool_ShapeExplorer(const TopoDS_Shape& S,const TopAbs_ShapeEnum ToFind,const TopAbs_ShapeEnum ToAvoid = TopAbs_SHAPE);


Standard_EXPORT   void Init(const TopoDS_Shape& S,const TopAbs_ShapeEnum ToFind,const TopAbs_ShapeEnum ToAvoid = TopAbs_SHAPE) ;

//! Returns  True if  there are   more  shapes in  the <br>
//!          exploration. <br>
Standard_EXPORT   Standard_Boolean More() const;

//! Moves to the next Shape in the exploration. <br>
Standard_EXPORT   void Next() ;

//! Returns the current shape in the exploration. <br>
Standard_EXPORT  const TopoDS_Shape& Current() const;


Standard_EXPORT   Standard_Integer NbShapes() const;


Standard_EXPORT   Standard_Integer Index() const;


Standard_EXPORT   Standard_OStream& DumpCurrent(Standard_OStream& OS) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopExp_Explorer myExplorer;
Standard_Integer myIndex;
Standard_Integer myNbShapes;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
