// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeUpgrade_WireDivide_HeaderFile
#define _ShapeUpgrade_WireDivide_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_WireDivide_HeaderFile
#include <Handle_ShapeUpgrade_WireDivide.hxx>
#endif

#ifndef _Handle_ShapeUpgrade_SplitCurve3d_HeaderFile
#include <Handle_ShapeUpgrade_SplitCurve3d.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_SplitCurve2d_HeaderFile
#include <Handle_ShapeUpgrade_SplitCurve2d.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_EdgeDivide_HeaderFile
#include <Handle_ShapeUpgrade_EdgeDivide.hxx>
#endif
#ifndef _Handle_ShapeAnalysis_TransferParameters_HeaderFile
#include <Handle_ShapeAnalysis_TransferParameters.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopoDS_Wire_HeaderFile
#include <TopoDS_Wire.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_FixSmallCurves_HeaderFile
#include <Handle_ShapeUpgrade_FixSmallCurves.hxx>
#endif
#ifndef _ShapeUpgrade_Tool_HeaderFile
#include <ShapeUpgrade_Tool.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
class ShapeUpgrade_SplitCurve3d;
class ShapeUpgrade_SplitCurve2d;
class ShapeUpgrade_EdgeDivide;
class ShapeAnalysis_TransferParameters;
class ShapeUpgrade_FixSmallCurves;
class TopoDS_Wire;
class TopoDS_Face;
class Geom_Surface;
class TopoDS_Edge;
class TopLoc_Location;


//! Divides edges in the wire lying on the face or free wires or <br>
//!          free edges with a criterion. <br>
//!          Splits 3D curve and pcurve(s) of the edge on the face. <br>
//!          Other pcurves which may be associated with the edge are simply <br>
//!          copied. <br>
//!          If 3D curve is splitted then pcurve on the face is splitted as <br>
//!          well, and wice-versa. <br>
//!          Input shape is not modified. <br>
//!          The modifications made are recorded in external context <br>
//!          (ShapeBuild_ReShape). This tool is applied to all edges <br>
//!          before splitting them in order to keep sharing. <br>
class ShapeUpgrade_WireDivide : public ShapeUpgrade_Tool {

public:
 // Methods PUBLIC
 // 

//! Empty constructor <br>
Standard_EXPORT ShapeUpgrade_WireDivide();

//! Initializes by wire and face <br>
Standard_EXPORT   void Init(const TopoDS_Wire& W,const TopoDS_Face& F) ;

//! Initializes by wire and surface <br>
Standard_EXPORT   void Init(const TopoDS_Wire& W,const Handle(Geom_Surface)& S) ;

//! Loads working wire <br>
Standard_EXPORT   void Load(const TopoDS_Wire& W) ;

//! Creates wire of one edge and calls Load for wire <br>
Standard_EXPORT   void Load(const TopoDS_Edge& E) ;

//! Sets supporting surface by face <br>
Standard_EXPORT   void SetFace(const TopoDS_Face& F) ;

//! Sets supporting surface <br>
Standard_EXPORT   void SetSurface(const Handle(Geom_Surface)& S) ;

//! Sets supporting surface with location <br>
Standard_EXPORT   void SetSurface(const Handle(Geom_Surface)& S,const TopLoc_Location& L) ;

//! Computes the resulting wire by splitting all the edges <br>
//!          according to splitting criteria. <br>
//!          All the modifications made are recorded in context <br>
//!          (ShapeBuild_ReShape). This tool is applied to all edges <br>
//!          before splitting them in order to keep sharings. <br>
//!          If no supporting face or surface is defined, only 3d <br>
//!          splitting criteria are used. <br>
Standard_EXPORT virtual  void Perform() ;

//! Gives the resulting Wire (equal to initial one if not done <br>
//!          or Null if not loaded) <br>
Standard_EXPORT  const TopoDS_Wire& Wire() const;

//! Queries status of last call to Perform() <br>
//! OK - no edges were splitted, wire left untouched <br>
//! DONE1 - some edges were splitted <br>
//! FAIL1 - some edges have no 3d curve (skipped) <br>
//! FAIL2 - some edges have no pcurve (skipped) <br>
Standard_EXPORT   Standard_Boolean Status(const ShapeExtend_Status status) const;

//! Sets the tool for splitting 3D curves. <br>
Standard_EXPORT   void SetSplitCurve3dTool(const Handle(ShapeUpgrade_SplitCurve3d)& splitCurve3dTool) ;

//! Sets the tool for splitting pcurves. <br>
Standard_EXPORT   void SetSplitCurve2dTool(const Handle(ShapeUpgrade_SplitCurve2d)& splitCurve2dTool) ;

//! Sets the tool for Transfer parameters between curves and pcurves. <br>
Standard_EXPORT   void SetTransferParamTool(const Handle(ShapeAnalysis_TransferParameters)& TransferParam) ;

//! Sets tool for splitting edge <br>
Standard_EXPORT   void SetEdgeDivideTool(const Handle(ShapeUpgrade_EdgeDivide)& edgeDivideTool) ;

//! returns tool for splitting edges <br>
Standard_EXPORT virtual  Handle_ShapeUpgrade_EdgeDivide GetEdgeDivideTool() const;

//! Returns the tool for Transfer of parameters. <br>
Standard_EXPORT virtual  Handle_ShapeAnalysis_TransferParameters GetTransferParamTool() ;

//!Sets mode for splitting 3d curves from edges. <br>
//! 0 - only curve 3d from free edges. <br>
//! 1 - only curve 3d from shared edges. <br>
//! 2 -  all curve 3d. <br>
Standard_EXPORT   void SetEdgeMode(const Standard_Integer EdgeMode) ;

//!Sets tool for fixing small curves with specified min tolerance; <br>
Standard_EXPORT   void SetFixSmallCurveTool(const Handle(ShapeUpgrade_FixSmallCurves)& FixSmallCurvesTool) ;

//!Returns tool for fixing small curves <br>
Standard_EXPORT   Handle_ShapeUpgrade_FixSmallCurves GetFixSmallCurveTool() const;
//Standard_EXPORT ~ShapeUpgrade_WireDivide();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Returns the tool for splitting 3D curves. <br>
Standard_EXPORT virtual  Handle_ShapeUpgrade_SplitCurve3d GetSplitCurve3dTool() const;

//! Returns the tool for splitting pcurves. <br>
Standard_EXPORT virtual  Handle_ShapeUpgrade_SplitCurve2d GetSplitCurve2dTool() const;


 // Fields PROTECTED
 //
TopoDS_Face myFace;
TopoDS_Wire myWire;
Standard_Integer myStatus;
Standard_Integer myEdgeMode;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_ShapeUpgrade_SplitCurve3d mySplitCurve3dTool;
Handle_ShapeUpgrade_SplitCurve2d mySplitCurve2dTool;
Handle_ShapeUpgrade_EdgeDivide myEdgeDivide;
Handle_ShapeAnalysis_TransferParameters myTransferParamTool;
Handle_ShapeUpgrade_FixSmallCurves myFixSmallCurveTool;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
