// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeProcess_HeaderFile
#define _ShapeProcess_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_ShapeProcess_Operator_HeaderFile
#include <Handle_ShapeProcess_Operator.hxx>
#endif
#ifndef _Handle_ShapeProcess_Context_HeaderFile
#include <Handle_ShapeProcess_Context.hxx>
#endif
class ShapeProcess_Operator;
class ShapeProcess_Context;
class ShapeProcess_Context;
class ShapeProcess_ShapeContext;
class ShapeProcess_Operator;
class ShapeProcess_UOperator;
class ShapeProcess_OperLibrary;
class ShapeProcess_DictionaryOfOperator;
class ShapeProcess_IteratorOfDictionaryOfOperator;
class ShapeProcess_StackItemOfDictionaryOfOperator;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Shape Processing module <br>
//! allows to define and apply general Shape Processing as a <br>
//! customizable sequence of Shape Healing operators. The <br>
//! customization is implemented via user-editable resource <br>
//! file which defines sequence of operators to be executed <br>
//! and their parameters. <br>
class ShapeProcess  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Registers operator to make it visible for Performer <br>
Standard_EXPORT static  Standard_Boolean RegisterOperator(const Standard_CString name,const Handle(ShapeProcess_Operator)& op) ;

//! Finds operator by its name <br>
Standard_EXPORT static  Standard_Boolean FindOperator(const Standard_CString name,Handle(ShapeProcess_Operator)& op) ;

//! Performs a specified sequence of operators on Context <br>
//!          Resource file and other data should be already loaded <br>
//!          to Context (including description of sequence seq) <br>
Standard_EXPORT static  Standard_Boolean Perform(const Handle(ShapeProcess_Context)& context,const Standard_CString seq) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class ShapeProcess_Context;
friend class ShapeProcess_ShapeContext;
friend class ShapeProcess_Operator;
friend class ShapeProcess_UOperator;
friend class ShapeProcess_OperLibrary;
friend class ShapeProcess_DictionaryOfOperator;
friend class ShapeProcess_IteratorOfDictionaryOfOperator;
friend class ShapeProcess_StackItemOfDictionaryOfOperator;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
