// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Select3D_SensitiveSegment_HeaderFile
#define _Select3D_SensitiveSegment_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Select3D_SensitiveSegment_HeaderFile
#include <Handle_Select3D_SensitiveSegment.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Select3D_Pnt_HeaderFile
#include <Select3D_Pnt.hxx>
#endif
#ifndef _Select3D_Pnt2d_HeaderFile
#include <Select3D_Pnt2d.hxx>
#endif
#ifndef _Select3D_SensitiveEntity_HeaderFile
#include <Select3D_SensitiveEntity.hxx>
#endif
#ifndef _Handle_SelectBasics_EntityOwner_HeaderFile
#include <Handle_SelectBasics_EntityOwner.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Handle_Select3D_SensitiveEntity_HeaderFile
#include <Handle_Select3D_SensitiveEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class SelectBasics_EntityOwner;
class gp_Pnt;
class Select3D_Projector;
class SelectBasics_ListOfBox2d;
class Select3D_SensitiveEntity;
class TopLoc_Location;
class TColgp_Array1OfPnt2d;
class Bnd_Box2d;
class gp_Lin;


//! A framework to define sensitive zones along a segment <br>
//!          One gives the 3D start and end point; <br>
//!          the maximum number of 2D boxes given <br>
//!          by this entity may be set by the user <br>
//!          if the projected segment is <br>
//!          vertical or horizontal, one needs only 1 box. <br>
//!          for a pi/4 angle -> MaxNumber 2D boxes <br>
class Select3D_SensitiveSegment : public Select3D_SensitiveEntity {

public:
 // Methods PUBLIC
 // 

//! Constructs the sensitive segment object defined by <br>
//! the owner OwnerId, the points FirstP, LastP and the <br>
//! maximum number of sensitive bounding boxes MaxRect. <br>
Standard_EXPORT Select3D_SensitiveSegment(const Handle(SelectBasics_EntityOwner)& OwnerId,const gp_Pnt& FirstP,const gp_Pnt& LastP,const Standard_Integer MaxRect = 1);
//!  Sets the maximum number of sensitive rectangles MaxRect. <br>
  void Set(const Standard_Integer MaxRect) ;
//! changes the start Point of the Segment; <br>
  void StartPoint(const gp_Pnt& aPt) ;
//! changes the end point of the segment <br>
  void EndPoint(const gp_Pnt& aPt) ;
//! gives the 3D start Point of the Segment <br>
  gp_Pnt StartPoint() const;
//! gives the 3D End Point of the Segment <br>
  gp_Pnt EndPoint() const;

//! projection of the sensitive primitive in order to <br>
//!          get 2D boxes for the Sort Algorithm <br>
Standard_EXPORT virtual  void Project(const Select3D_Projector& aProjector) ;

//! gives the 2D boxes which represent the segment in the <br>
//!          selection process... <br>
Standard_EXPORT   void Areas(SelectBasics_ListOfBox2d& boxes) ;


Standard_EXPORT   Handle_Select3D_SensitiveEntity GetConnected(const TopLoc_Location& aLocation) ;

//! projection of the sensitive primitive in order to <br>
//!          get 2D boxes for the Sort Algorithm <br>
Standard_EXPORT   Standard_Boolean Matches(const Standard_Real X,const Standard_Real Y,const Standard_Real aTol,Standard_Real& DMin) ;


Standard_EXPORT   Standard_Boolean Matches(const Standard_Real XMin,const Standard_Real YMin,const Standard_Real XMax,const Standard_Real YMax,const Standard_Real aTol) ;


Standard_EXPORT virtual  Standard_Boolean Matches(const TColgp_Array1OfPnt2d& Polyline,const Bnd_Box2d& aBox,const Standard_Real aTol) ;


Standard_EXPORT   Standard_Real ComputeDepth(const gp_Lin& EyeLine) const;
//!returns <mymaxrect> <br>
  Standard_Integer MaxBoxes() const;


Standard_EXPORT virtual  void Dump(Standard_OStream& S,const Standard_Boolean FullDump = Standard_True) const;
//Standard_EXPORT ~Select3D_SensitiveSegment();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer mymaxrect;
Select3D_Pnt mystart;
Select3D_Pnt myend;
Select3D_Pnt2d myprojstart;
Select3D_Pnt2d myprojend;


};


#include <Select3D_SensitiveSegment.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
