// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Select3D_SensitiveBox_HeaderFile
#define _Select3D_SensitiveBox_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Select3D_SensitiveBox_HeaderFile
#include <Handle_Select3D_SensitiveBox.hxx>
#endif

#ifndef _Bnd_Box_HeaderFile
#include <Bnd_Box.hxx>
#endif
#ifndef _Bnd_Box2d_HeaderFile
#include <Bnd_Box2d.hxx>
#endif
#ifndef _Select3D_SensitiveEntity_HeaderFile
#include <Select3D_SensitiveEntity.hxx>
#endif
#ifndef _Handle_SelectBasics_EntityOwner_HeaderFile
#include <Handle_SelectBasics_EntityOwner.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Select3D_SensitiveEntity_HeaderFile
#include <Handle_Select3D_SensitiveEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class SelectBasics_EntityOwner;
class Bnd_Box;
class Select3D_Projector;
class SelectBasics_ListOfBox2d;
class Select3D_SensitiveEntity;
class TopLoc_Location;
class TColgp_Array1OfPnt2d;
class Bnd_Box2d;
class gp_Lin;


//! A framework to define selection by a sensitive box. <br>
class Select3D_SensitiveBox : public Select3D_SensitiveEntity {

public:
 // Methods PUBLIC
 // 

//! Constructs a sensitive box object defined by the <br>
//! owner OwnerId, and the bounding box BoundingBox. <br>
Standard_EXPORT Select3D_SensitiveBox(const Handle(SelectBasics_EntityOwner)& OwnerId,const Bnd_Box& BoundingBox);

//! Constructs a sensitive box object defined by the <br>
//! owner OwnerId, and the coordinates Xmin, YMin, ZMin, XMax, YMax, ZMax. <br>
//! Xmin, YMin and ZMin define the minimum point in <br>
//! the front lower left hand corner of the box, <br>
//! and   XMax, YMax   and ZMax define the maximum <br>
//! point in the back upper right hand corner of the box. <br>
Standard_EXPORT Select3D_SensitiveBox(const Handle(SelectBasics_EntityOwner)& OwnerId,const Standard_Real XMin,const Standard_Real YMin,const Standard_Real ZMin,const Standard_Real XMax,const Standard_Real YMax,const Standard_Real ZMax);

//! projection of the sensitive primitive in order to <br>
//!          get 2D boxes for the Sort Algorithm <br>
Standard_EXPORT   void Project(const Select3D_Projector& aProjector) ;

//! gives the 2D boxes which represent the Box in the <br>
//!          selection process... <br>
Standard_EXPORT   void Areas(SelectBasics_ListOfBox2d& boxes) ;


Standard_EXPORT   Handle_Select3D_SensitiveEntity GetConnected(const TopLoc_Location& aLocation) ;


//! <br>
Standard_EXPORT   Standard_Boolean Matches(const Standard_Real X,const Standard_Real Y,const Standard_Real aTol,Standard_Real& DMin) ;


Standard_EXPORT   Standard_Boolean Matches(const Standard_Real XMin,const Standard_Real YMin,const Standard_Real XMax,const Standard_Real YMax,const Standard_Real aTol) ;


Standard_EXPORT virtual  Standard_Boolean Matches(const TColgp_Array1OfPnt2d& Polyline,const Bnd_Box2d& aBox,const Standard_Real aTol) ;


Standard_EXPORT   Standard_Real ComputeDepth(const gp_Lin& EyeLine) const;


Standard_EXPORT virtual  void Dump(Standard_OStream& S,const Standard_Boolean FullDump = Standard_True) const;
//! Returns the sensitive 3D box used at the time of construction. <br>
 const Bnd_Box& Box() const;
//Standard_EXPORT ~Select3D_SensitiveBox();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void ProjectBox(const Select3D_Projector& aPrj,const Bnd_Box& aBox) ;


 // Fields PRIVATE
 //
Bnd_Box mybox3d;
Bnd_Box2d mybox2d;


};


#include <Select3D_SensitiveBox.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
