// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Select2D_SensitiveCircle_HeaderFile
#define _Select2D_SensitiveCircle_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Select2D_SensitiveCircle_HeaderFile
#include <Handle_Select2D_SensitiveCircle.hxx>
#endif

#ifndef _gp_Circ2d_HeaderFile
#include <gp_Circ2d.hxx>
#endif
#ifndef _Select2D_TypeOfSelection_HeaderFile
#include <Select2D_TypeOfSelection.hxx>
#endif
#ifndef _Select2D_SensitiveEntity_HeaderFile
#include <Select2D_SensitiveEntity.hxx>
#endif
#ifndef _Handle_SelectBasics_EntityOwner_HeaderFile
#include <Handle_SelectBasics_EntityOwner.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class SelectBasics_EntityOwner;
class gp_Circ2d;
class SelectBasics_ListOfBox2d;


//! A framework to define sensitive Areas for a Circle <br>
//!           Radius and center, or a geometric circle is given. <br>
class Select2D_SensitiveCircle : public Select2D_SensitiveEntity {

public:
 // Methods PUBLIC
 // 

//! Constructs a sensitive circle object defined by the <br>
//! owner OwnerId, the circle Circle, and the selection type Type. <br>
//! Type can be: <br>
//! -   interior <br>
//! -   boundary. <br>
Standard_EXPORT Select2D_SensitiveCircle(const Handle(SelectBasics_EntityOwner)& OwnerId,const gp_Circ2d& TheCirc,const Select2D_TypeOfSelection TheType = Select2D_TOS_BOUNDARY);

//! returns the sensitive areas for a circle... <br>
Standard_EXPORT   void Areas(SelectBasics_ListOfBox2d& aresul) ;

//! Returns true if the minimum distance DMin <br>
//!          between the postion x,y and the circle is less than aTol.. <br>
Standard_EXPORT   Standard_Boolean Matches(const Standard_Real X,const Standard_Real Y,const Standard_Real aTol,Standard_Real& DMin) ;


Standard_EXPORT   Standard_Boolean Matches(const Standard_Real XMin,const Standard_Real YMin,const Standard_Real XMax,const Standard_Real YMax,const Standard_Real aTol) ;
//! Returns the circle used at the time of construction of this object. <br>
 const gp_Circ2d& Circle() const;
//! Sets the selection type. <br>
  void SetTypeOfSelection(const Select2D_TypeOfSelection aType) ;
//! Returns the selection type used at the time of construction of this object. <br>
  Select2D_TypeOfSelection Selection() ;
//Standard_EXPORT ~Select2D_SensitiveCircle();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Circ2d myCirc;
Select2D_TypeOfSelection mytype;


};


#include <Select2D_SensitiveCircle.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
