// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _PS_Driver_HeaderFile
#define _PS_Driver_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_PS_Driver_HeaderFile
#include <Handle_PS_Driver.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _PlotMgt_PlotterDriver_HeaderFile
#include <PlotMgt_PlotterDriver.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Aspect_TypeOfColorSpace_HeaderFile
#include <Aspect_TypeOfColorSpace.hxx>
#endif
#ifndef _Aspect_FormatOfSheetPaper_HeaderFile
#include <Aspect_FormatOfSheetPaper.hxx>
#endif
#ifndef _Handle_PlotMgt_Plotter_HeaderFile
#include <Handle_PlotMgt_Plotter.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Aspect_ColorMap_HeaderFile
#include <Handle_Aspect_ColorMap.hxx>
#endif
#ifndef _Handle_Aspect_TypeMap_HeaderFile
#include <Handle_Aspect_TypeMap.hxx>
#endif
#ifndef _Handle_Aspect_WidthMap_HeaderFile
#include <Handle_Aspect_WidthMap.hxx>
#endif
#ifndef _Handle_Aspect_FontMap_HeaderFile
#include <Handle_Aspect_FontMap.hxx>
#endif
#ifndef _Handle_Aspect_MarkMap_HeaderFile
#include <Handle_Aspect_MarkMap.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Aspect_TypeOfText_HeaderFile
#include <Aspect_TypeOfText.hxx>
#endif
#ifndef _Quantity_Ratio_HeaderFile
#include <Quantity_Ratio.hxx>
#endif
class Aspect_DriverError;
class PlotMgt_Plotter;
class Aspect_ColorMap;
class Aspect_TypeMap;
class Aspect_WidthMap;
class Aspect_FontMap;
class Aspect_MarkMap;
class TCollection_ExtendedString;


//! This class defines a PS (Adobe PostScript) plotter Driver. <br>
//!         All necessary information about methods (purpose, level, category, etc.) <br>
//!         can be found in CDL files from the inheritance tree (PlotMgt_PlotterDriver, <br>
//!         Aspect_Driver). <br>
class PS_Driver : public PlotMgt_PlotterDriver {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT PS_Driver(const Standard_CString aName,const Quantity_Length aDX,const Quantity_Length aDY,const Aspect_TypeOfColorSpace aTypeOfColorSpace = Aspect_TOCS_RGB,const Aspect_FormatOfSheetPaper aSheetFormat = Aspect_FOSP_A4);

//! Constructs a file called aName as the graphic <br>
//! plotter file. The parameters of the plotter aPlotter <br>
//! are taken into account for defining this plotter file. <br>
//! aPaperX,aPaperY defines the size of the <br>
//! sheet-paper and the value of aTypeOfColorSpace <br>
//! defines the mode for processing colors. <br>
Standard_EXPORT PS_Driver(const Handle(PlotMgt_Plotter)& aPlotter,const Standard_CString aName,const Quantity_Length aPaperX,const Quantity_Length aPaperY,const Aspect_TypeOfColorSpace aTypeOfColorSpace = Aspect_TOCS_RGB);


//! Begins a new page of graphics in the plotter file called "aName". <br>
Standard_EXPORT   void BeginDraw() ;


Standard_EXPORT   void EndDraw(const Standard_Boolean dontFlush = Standard_False) ;


Standard_EXPORT virtual  void SetTextAttrib(const Standard_Integer ColorIndex,const Standard_Integer FontIndex) ;


Standard_EXPORT virtual  void SetTextAttrib(const Standard_Integer ColorIndex,const Standard_Integer FontIndex,const Quantity_PlaneAngle aSlant,const Quantity_Factor aHScale,const Quantity_Factor aWScale,const Standard_Boolean isUnderlined = Standard_False) ;


Standard_EXPORT virtual  Standard_Boolean SizeOfImageFile(const Standard_CString anImageFile,Standard_Integer& aWidth,Standard_Integer& aHeight) const;
//Standard_EXPORT ~PS_Driver();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT virtual  void InitializeColorMap(const Handle(Aspect_ColorMap)& aColorMap) ;


Standard_EXPORT virtual  void InitializeTypeMap(const Handle(Aspect_TypeMap)& aTypeMap) ;


Standard_EXPORT virtual  void InitializeWidthMap(const Handle(Aspect_WidthMap)& aWidthMap) ;


Standard_EXPORT virtual  void InitializeFontMap(const Handle(Aspect_FontMap)& aFontMap) ;


Standard_EXPORT virtual  void InitializeMarkMap(const Handle(Aspect_MarkMap)& aFontMap) ;


Standard_EXPORT virtual  void PlotLineAttrib(const Standard_Integer ColorIndex,const Standard_Integer TypeIndex,const Standard_Integer WidthIndex) ;


Standard_EXPORT virtual  Standard_Boolean PlotPoint(const Standard_ShortReal X,const Standard_ShortReal Y) ;


Standard_EXPORT virtual  Standard_Boolean PlotSegment(const Standard_ShortReal X1,const Standard_ShortReal Y1,const Standard_ShortReal X2,const Standard_ShortReal Y2) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolyline(const Standard_Address xArray,const Standard_Address yArray,const Standard_Address nPts,const Standard_Integer nParts) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolygon(const Standard_Address xArray,const Standard_Address yArray,const Standard_Address nPts,const Standard_Integer nParts) ;


Standard_EXPORT virtual  Standard_Boolean PlotArc(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal anXradius,const Standard_ShortReal anYradius,const Standard_ShortReal sAngle,const Standard_ShortReal oAngle) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolyArc(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal anXradius,const Standard_ShortReal anYradius,const Standard_ShortReal sAngle,const Standard_ShortReal oAngle) ;


Standard_EXPORT virtual  Standard_Boolean PlotMarker(const Standard_Integer aMarker,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal Width,const Standard_ShortReal Height,const Standard_ShortReal Angle) ;


Standard_EXPORT virtual  Standard_Boolean PlotText(const TCollection_ExtendedString& aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal anAngle,const Aspect_TypeOfText aType) ;


Standard_EXPORT virtual  Standard_Boolean PlotText(const Standard_CString aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Standard_ShortReal anAngle,const Aspect_TypeOfText aType) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolyText(const TCollection_ExtendedString& aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Quantity_Ratio aMargin,const Standard_ShortReal anAngle,const Aspect_TypeOfText aType) ;


Standard_EXPORT virtual  Standard_Boolean PlotPolyText(const Standard_CString aText,const Standard_ShortReal Xpos,const Standard_ShortReal Ypos,const Quantity_Ratio aMargin,const Standard_ShortReal anAngle,const Aspect_TypeOfText aType) ;


Standard_EXPORT virtual  Standard_Boolean PlotImage(const Standard_ShortReal aX,const Standard_ShortReal aY,const Standard_ShortReal aWidth,const Standard_ShortReal aHeight,const Standard_ShortReal aScale,const Standard_CString anImageFile,const Standard_Address anArrayOfPixels,const Standard_Integer aLineIndex = -1) ;


Standard_EXPORT virtual  Standard_Boolean DrawCurveCapable() const;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void BeginFile(const Handle(PlotMgt_Plotter)& aPlotter,const Standard_CString aName,const Quantity_Length aDX,const Quantity_Length aDY,const Aspect_TypeOfColorSpace aTypeOfColorSpace,const Quantity_Length aPaperX,const Quantity_Length aPaperY) ;

//! For this driver <br>
//! - returns the DPU (device plotter unit) value <br>
//!   corresponding to the number of pixels PV, or <br>
//! - returns the number of pixels corresponding to the DPU value DV, or <br>
//! - returns the DPU coordinates (DX,DY) <br>
//!   corresponding to the pixel position (PX,PY), or <br>
//! - returns the pixel position (PX,PY) corresponding to <br>
//!   the DPU coordinates (DX,DY). <br>
//!   The DPU value is specified in millimeters by default. <br>
//! Warning <br>
//! The pixel size is 325mm/1152 by default and can be <br>
//! changed with the SetPixelSize function. <br>
Standard_EXPORT   Standard_ShortReal Convert(const Standard_ShortReal aShortReal) const;


Standard_EXPORT virtual  Standard_ShortReal MapX(const Standard_ShortReal aShortReal) const;


Standard_EXPORT virtual  Standard_ShortReal MapY(const Standard_ShortReal aShortReal) const;


 // Fields PRIVATE
 //
Standard_Integer myCurrentPage;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
