// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_Host_HeaderFile
#define _OSD_Host_HeaderFile

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _OSD_Error_HeaderFile
#include <OSD_Error.hxx>
#endif
#ifndef _OSD_SysType_HeaderFile
#include <OSD_SysType.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _OSD_OEMType_HeaderFile
#include <OSD_OEMType.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class Standard_NullObject;
class OSD_OSDError;
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Carries information about a Host <br>
class OSD_Host  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes current host by default. <br>
Standard_EXPORT OSD_Host();

//! Returns system name and version <br>
Standard_EXPORT   TCollection_AsciiString SystemVersion() ;

//! Returns the system type (UNIX System V, UNIX BSD, MS-DOS...) <br>
Standard_EXPORT   OSD_SysType SystemId() const;

//! Returns host name. <br>
Standard_EXPORT   TCollection_AsciiString HostName() ;

//! Returns available memory in Kilobytes. <br>
Standard_EXPORT   Standard_Integer AvailableMemory() ;

//! Returns Internet address of current host. <br>
Standard_EXPORT   TCollection_AsciiString InternetAddress() ;

//! Returns Ethernet address of current host. <br>
Standard_EXPORT   TCollection_AsciiString EthernetAddress() ;

//! Returns type of current machine. <br>
Standard_EXPORT   OSD_OEMType MachineType() ;

//! Returns TRUE if an error occurs <br>
Standard_EXPORT   Standard_Boolean Failed() const;

//! Resets error counter to zero <br>
Standard_EXPORT   void Reset() ;

//! Raises OSD_Error <br>
Standard_EXPORT   void Perror() ;

//! Returns error number if 'Failed' is TRUE. <br>
Standard_EXPORT   Standard_Integer Error() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString myName;
OSD_Error myError;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
