// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_Disk_HeaderFile
#define _OSD_Disk_HeaderFile

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _OSD_Error_HeaderFile
#include <OSD_Error.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class OSD_OSDError;
class OSD_Path;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Disk management <br>
class OSD_Disk  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a disk object. <br>
//!          This is used only when a class contains a Disk field. <br>
//!          By default, its name is initialized to current working disk. <br>
Standard_EXPORT OSD_Disk();

//! Initializes the object Disk with the disk name <br>
//!          associated to the OSD_Path. <br>
Standard_EXPORT OSD_Disk(const OSD_Path& Name);

//! Initializes the object Disk with <PathName>. <br>
//!          <PathName> specifies any file within the mounted <br>
//!          file system. <br>
//!          Example : OSD_Disk myDisk ("/tmp") <br>
//!                    Initializes a disk object with the mounted <br>
//!                    file associated to /tmp. <br>
Standard_EXPORT OSD_Disk(const Standard_CString PathName);

//! Returns disk name of <me>. <br>
Standard_EXPORT   OSD_Path Name() const;

//! Instantiates <me> with <Name>. <br>
Standard_EXPORT   void SetName(const OSD_Path& Name) ;

//! Returns total disk capacity in 512 bytes blocks. <br>
Standard_EXPORT   Standard_Integer DiskSize() ;

//! Returns free available 512 bytes blocks on disk. <br>
Standard_EXPORT   Standard_Integer DiskFree() ;

//! Returns user's disk quota (in Bytes). <br>
Standard_EXPORT   Standard_Integer DiskQuota() ;

//! Sets user's disk quota (in Bytes). <br>
//!  Warning: Needs system administrator privilege. <br>
Standard_EXPORT   void SetDiskQuota(const Standard_Integer QuotaSize) ;

//! Activates user's disk quota <br>
//!  Warning: Needs system administrator privilege. <br>
Standard_EXPORT   void SetQuotaOn() ;

//! Deactivates user's disk quota <br>
//!  Warning: Needs system administrator privilege. <br>
Standard_EXPORT   void SetQuotaOff() ;

//! Returns TRUE if an error occurs <br>
Standard_EXPORT   Standard_Boolean Failed() const;

//! Resets error counter to zero <br>
Standard_EXPORT   void Reset() ;

//! Raises OSD_Error <br>
Standard_EXPORT   void Perror() ;

//! Returns error number if 'Failed' is TRUE. <br>
Standard_EXPORT   Standard_Integer Error() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString DiskName;
Standard_Integer myQuotaSize;
OSD_Error myError;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
