// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MgtBRep_HeaderFile
#define _MgtBRep_HeaderFile

#ifndef _Handle_PTopoDS_HShape_HeaderFile
#include <Handle_PTopoDS_HShape.hxx>
#endif
#ifndef _MgtBRep_TriangleMode_HeaderFile
#include <MgtBRep_TriangleMode.hxx>
#endif
class PTopoDS_HShape;
class TopoDS_Shape;
class PTColStd_TransientPersistentMap;
class PTopoDS_Shape1;
class PTColStd_PersistentTransientMap;
class MgtBRep_TranslateTool;
class MgtBRep_TranslateTool1;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The MgtBRep package  provides methods to translate <br>
//!          data  between  the  BRep    package and the  PBRep <br>
//!          package. <br>
//! <br>
//!          That  is   to    translate  persistent  BRep  data <br>
//!          structures  in  Transient BRep data structures and <br>
//!          vice-versa. <br>
//! <br>
//!          The MgtBRep package uses : <br>
//! <br>
//!          * The  MgtBas  package to bind  a  transient and a <br>
//!          persistent object. <br>
//! <br>
//!          * The  MgtTopoDS package to provide basic methods <br>
//!          to translate TopoDS and PTopoDS data. <br>
//! <br>
//!          * The MgtTopLoc package to translate Locations. <br>
//! <br>
//!          * The  MgtGeom,  MgtGeom2d  packages to translate <br>
//!          geometric data. <br>
//! <br>
//!          * The MgtPoly package to translate triangulation data. <br>
//! <br>
//!          The Translate methods has TriangleMode argument. <br>
//!          If it is MgtBRep_WithTriangle, the methods returns or <br>
//!          create a Shape with triangulation. <br>
class MgtBRep  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Translate a transient Shape to a persistent Shape. <br>
//!         he translation is performed according <br>
//!  to the map aMap and the triangulation <br>
//!  specified by aTriMode <br>
Standard_EXPORT static  Handle_PTopoDS_HShape Translate(const TopoDS_Shape& aShape,PTColStd_TransientPersistentMap& aMap,const MgtBRep_TriangleMode aTriMode) ;

//! Translate a transient Shape to a persistent Shape. <br>
//!	The translation is performed according to the map aMap and the <br>
//!   triangulation specified by aTriMode. <br>
//! The map, aMap, is a tool that lets you share <br>
//! topological components. When the map is <br>
//! initialized, it is empty. It is built up and used by the <br>
//! Translate function every time a topological <br>
//! component is converted from persistent to <br>
//! transient and vice versa. This is true for all <br>
//! topological components that can be shared: <br>
//! vertex, edge, wire, face, shell, solid, and so on. <br>
//! This map allows you to share individual <br>
//! components as they are translated, and also lets <br>
//! you share previously converted components <br>
//! when you translate other objects which share <br>
//! (i.e. refer to) these components. <br>
//! The triangulation mode, aTriMode, specifies <br>
//! whether a representation of the object as a set <br>
//! of triangles - if such a representation exists - is <br>
//! to be translated or not in addition to the <br>
//! canonical definition of the object. <br>
Standard_EXPORT static  void Translate1(const TopoDS_Shape& aShape,PTColStd_TransientPersistentMap& aMap,PTopoDS_Shape1& aResult,const MgtBRep_TriangleMode aTriMode) ;

//! Translate a persistent Shape to a transient Shape. <br>
//!          Used for upwards compatibility. <br>
Standard_EXPORT static  void Translate(const Handle(PTopoDS_HShape)& aShape,PTColStd_PersistentTransientMap& aMap,TopoDS_Shape& aResult,const MgtBRep_TriangleMode aTriMode) ;

//! Translate a persistent Shape to a transient Shape. <br>
Standard_EXPORT static  void Translate1(const PTopoDS_Shape1& aShape,PTColStd_PersistentTransientMap& aMap,TopoDS_Shape& aResult,const MgtBRep_TriangleMode aTriMode) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class MgtBRep_TranslateTool;
friend class MgtBRep_TranslateTool1;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
