// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MeshAlgo_Vertex_HeaderFile
#define _MeshAlgo_Vertex_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MeshDS_DegreeOfFreedom_HeaderFile
#include <MeshDS_DegreeOfFreedom.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class gp_XY;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes the data  structure for  a  vertex in  a <br>
//!          Delaunay triangulation. <br>
class MeshAlgo_Vertex  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT  const gp_XY& Coord() const;


Standard_EXPORT   MeshDS_DegreeOfFreedom Movability() const;


Standard_EXPORT   void SetMovability(const MeshDS_DegreeOfFreedom mov) ;

//! For maping the Vertices. <br>
//!          Same Vertex -> Same HashCode <br>
//!          Different Vertices -> Not IsEqual but can have same HashCode <br>
Standard_EXPORT   Standard_Integer Domain() const;


Standard_EXPORT   Standard_Integer HashCode(const Standard_Integer Upper) const;


Standard_EXPORT   Standard_Boolean IsEqual(const MeshAlgo_Vertex& Other) const;
  Standard_Boolean operator ==(const MeshAlgo_Vertex& Other) const
{
  return IsEqual(Other);
}






protected:

 // Methods PROTECTED
 // 


Standard_EXPORT MeshAlgo_Vertex(const Standard_Real x,const Standard_Real y,const Standard_Integer dom,const MeshDS_DegreeOfFreedom theMov);


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//
inline Standard_Integer HashCode(const MeshAlgo_Vertex& me,const Standard_Integer Upper) {
 return me.HashCode(Upper);
}



#endif
