// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MAT2d_SketchExplorer_HeaderFile
#define _MAT2d_SketchExplorer_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
class Geom2d_Curve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! SketchExplorer  is  an iterator on  a  sketch.   A <br>
//!          sketch is a set of contours, each contour is a set <br>
//!          of curves from Geom2d. <br>
class MAT2d_SketchExplorer  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns the number of contours in the figure. <br>
Standard_EXPORT   Standard_Integer NumberOfContours() const;

//! Initializes the curves explorer on the contour <br>
//!            of range <ContourIndex>. <br>
Standard_EXPORT   void Init(const Standard_Integer ContourIndex) ;

//! Returns False if  there is no  more curves on the <br>
//!           current contour. <br>
Standard_EXPORT   Standard_Boolean More() const;

//! Moves to the next curve of the current contour. <br>
Standard_EXPORT   void Next() ;

//! Returns the current curve on the current contour. <br>
Standard_EXPORT   Handle_Geom2d_Curve Value() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
