// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_Line_HeaderFile
#define _IGESGeom_Line_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_Line_HeaderFile
#include <Handle_IGESGeom_Line.hxx>
#endif

#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class gp_XYZ;
class gp_Pnt;


//! defines IGESLine, Type <110> Form <0> <br>
//!          in package IGESGeom <br>
//!          A line is a bounded, connected portion of a parent straight <br>
//!          line which consists of more than one point. A line is <br>
//!          defined by its end points. <br>
//! <br>
//!          From IGES-5.3, two other Forms are admitted (same params) : <br>
//!          0 remains for standard limited line (the default) <br>
//!          1 for semi-infinite line (End is just a passing point) <br>
//!          2 for full infinite Line (both Start and End are abitrary) <br>
class IGESGeom_Line : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_Line();

//! This method is used to set the fields of the class Line <br>
//!       - aStart : Start point of the line <br>
//!       - anEnd  : End point of the line <br>
Standard_EXPORT   void Init(const gp_XYZ& aStart,const gp_XYZ& anEnd) ;

//! Returns the Infinite status i.e. the Form Number : 0 1 2 <br>
Standard_EXPORT   Standard_Integer Infinite() const;

//! Sets the Infinite status <br>
//!           Does nothing if <status> is not 0 1 or 2 <br>
Standard_EXPORT   void SetInfinite(const Standard_Integer status) ;

//! returns the start point of the line <br>
Standard_EXPORT   gp_Pnt StartPoint() const;

//! returns the start point of the line after applying Transf. Matrix <br>
Standard_EXPORT   gp_Pnt TransformedStartPoint() const;

//! returns the end point of the line <br>
Standard_EXPORT   gp_Pnt EndPoint() const;

//! returns the end point of the line after applying Transf. Matrix <br>
Standard_EXPORT   gp_Pnt TransformedEndPoint() const;
//Standard_EXPORT ~IGESGeom_Line();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_XYZ theStart;
gp_XYZ theEnd;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
