// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESDraw_RectArraySubfigure_HeaderFile
#define _IGESDraw_RectArraySubfigure_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESDraw_RectArraySubfigure_HeaderFile
#include <Handle_IGESDraw_RectArraySubfigure.hxx>
#endif

#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class IGESData_IGESEntity;
class TColStd_HArray1OfInteger;
class Standard_OutOfRange;
class gp_XYZ;
class gp_Pnt;


//! Defines IGES Rectangular Array Subfigure Instance Entity, <br>
//!            Type <412> Form Number <0> in package IGESDraw <br>
//!            Used to produce copies of object called the base entity, <br>
//!            arranging them in equally spaced rows and columns <br>
class IGESDraw_RectArraySubfigure : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESDraw_RectArraySubfigure();

//! This method is used to set the fields of the class <br>
//!           RectArraySubfigure <br>
//!       - aBase         : a base entity which is replicated <br>
//!       - aScale        : Scale Factor <br>
//!       - aCorner       : lower left hand corner for the entire array <br>
//!       - nbCols        : Number of columns of the array <br>
//!       - nbRows        : Number of rows of the array <br>
//!       - hDisp         : Column separations <br>
//!       - vtDisp        : Row separation <br>
//!       - rotationAngle : Rotation angle specified in radians <br>
//!       - allDont       : DO-DON'T flag to control which portion <br>
//!                         to display <br>
//!       - allNumPos     : List of positions to be or not to be <br>
//!                         displayed <br>
Standard_EXPORT   void Init(const Handle(IGESData_IGESEntity)& aBase,const Standard_Real aScale,const gp_XYZ& aCorner,const Standard_Integer nbCols,const Standard_Integer nbRows,const Standard_Real hDisp,const Standard_Real vtDisp,const Standard_Real rotationAngle,const Standard_Integer doDont,const Handle(TColStd_HArray1OfInteger)& allNumPos) ;

//! returns the base entity, copies of which are produced <br>
Standard_EXPORT   Handle_IGESData_IGESEntity BaseEntity() const;

//! returns the scale factor <br>
Standard_EXPORT   Standard_Real ScaleFactor() const;

//! returns coordinates of lower left hand corner for the entire array <br>
Standard_EXPORT   gp_Pnt LowerLeftCorner() const;

//! returns Transformed coordinates of lower left corner for the array <br>
Standard_EXPORT   gp_Pnt TransformedLowerLeftCorner() const;

//! returns number of columns in the array <br>
Standard_EXPORT   Standard_Integer NbColumns() const;

//! returns number of rows in the array <br>
Standard_EXPORT   Standard_Integer NbRows() const;

//! returns horizontal distance between columns <br>
Standard_EXPORT   Standard_Real ColumnSeparation() const;

//! returns vertical distance between rows <br>
Standard_EXPORT   Standard_Real RowSeparation() const;

//! returns rotation angle in radians <br>
Standard_EXPORT   Standard_Real RotationAngle() const;

//! returns True if (ListCount = 0) i.e., all elements to be displayed <br>
Standard_EXPORT   Standard_Boolean DisplayFlag() const;

//! returns 0 if all replicated entities to be displayed <br>
Standard_EXPORT   Standard_Integer ListCount() const;

//! returns 0 if half or fewer of the elements of  the array are defined <br>
//!         1 if half or more of the elements are defined <br>
Standard_EXPORT   Standard_Boolean DoDontFlag() const;

//! returns whether Index is to be processed (DO) <br>
//! or not to be processed(DON'T) <br>
//! if (ListCount = 0) return theDoDontFlag <br>
Standard_EXPORT   Standard_Boolean PositionNum(const Standard_Integer Index) const;

//! returns the Index'th value position <br>
//! raises exception if Index <= 0 or Index > ListCount() <br>
Standard_EXPORT   Standard_Integer ListPosition(const Standard_Integer Index) const;
//Standard_EXPORT ~IGESDraw_RectArraySubfigure();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESData_IGESEntity theBaseEntity;
Standard_Real theScaleFactor;
gp_XYZ theLowerLeftCorner;
Standard_Integer theNbColumns;
Standard_Integer theNbRows;
Standard_Real theColumnSeparation;
Standard_Real theRowSeparation;
Standard_Real theRotationAngle;
Standard_Integer theDoDontFlag;
Handle_TColStd_HArray1OfInteger thePositions;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
