// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_CheckCounter_HeaderFile
#define _IFSelect_CheckCounter_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_CheckCounter_HeaderFile
#include <Handle_IFSelect_CheckCounter.hxx>
#endif

#ifndef _Handle_MoniTool_SignText_HeaderFile
#include <Handle_MoniTool_SignText.hxx>
#endif
#ifndef _IFSelect_SignatureList_HeaderFile
#include <IFSelect_SignatureList.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
class MoniTool_SignText;
class Interface_CheckIterator;
class Interface_InterfaceModel;


//! A CheckCounter allows to see a CheckList (i.e. CheckIterator) <br>
//!           not per entity, its messages, but per message, the entities <br>
//!           attached (count and list). Because many messages can be <br>
//!           repeated if they are due to systematic errors <br>
class IFSelect_CheckCounter : public IFSelect_SignatureList {

public:
 // Methods PUBLIC
 // 

//! Creates a CheckCounter, empty ready to work <br>
Standard_EXPORT IFSelect_CheckCounter(const Standard_Boolean withlist = Standard_False);

//! Sets a specific signature <br>
//!           Else, the current SignType (in the model) is used <br>
Standard_EXPORT   void SetSignature(const Handle(MoniTool_SignText)& sign) ;

//! Returns the Signature; <br>
Standard_EXPORT   Handle_MoniTool_SignText Signature() const;

//! Analyses a CheckIterator according a Model (which detains the <br>
//!           entities for which the CheckIterator has messages), i.e. <br>
//!           counts messages for entities <br>
//!           If <original> is True, does not consider final messages but <br>
//!             those before interpretation (such as inserting variables : <br>
//!             integers, reals, strings) <br>
//!           If <failsonly> is True, only Fails are considered <br>
//!           Remark : global messages are recorded with a Null entity <br>
Standard_EXPORT   void Analyse(const Interface_CheckIterator& list,const Handle(Interface_InterfaceModel)& model,const Standard_Boolean original = Standard_False,const Standard_Boolean failsonly = Standard_False) ;
//Standard_EXPORT ~IFSelect_CheckCounter();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_MoniTool_SignText thesign;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
