// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFGraph_AllShared_HeaderFile
#define _IFGraph_AllShared_HeaderFile

#ifndef _Interface_Graph_HeaderFile
#include <Interface_Graph.hxx>
#endif
#ifndef _Interface_GraphContent_HeaderFile
#include <Interface_GraphContent.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class Interface_Graph;
class Standard_Transient;
class Interface_EntityIterator;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! this class determines all Entities shared by some specific <br>
//!           ones, at any level (those which will be lead in a Transfer <br>
//!           for instance) <br>
class IFGraph_AllShared  : public Interface_GraphContent {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! creates an AllShared from a graph, empty ready to be filled <br>
Standard_EXPORT IFGraph_AllShared(const Interface_Graph& agraph);

//! creates an AllShared which memrizes Entities shared by a given <br>
//!           one, at any level, including itself <br>
Standard_EXPORT IFGraph_AllShared(const Interface_Graph& agraph,const Handle(Standard_Transient)& ent);

//! adds an entity and its shared ones to the list (allows to <br>
//!           cumulate all Entities shared by some ones) <br>
Standard_EXPORT   void GetFromEntity(const Handle(Standard_Transient)& ent) ;

//! Adds Entities from an EntityIterator and all their shared <br>
//!           ones at any level <br>
Standard_EXPORT   void GetFromIter(const Interface_EntityIterator& iter) ;

//! Allows to restart on a new data set <br>
Standard_EXPORT   void ResetData() ;

//! does the specific evaluation (shared entities atall levels) <br>
Standard_EXPORT virtual  void Evaluate() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Interface_Graph thegraph;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
