// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRBRep_Intersector_HeaderFile
#define _HLRBRep_Intersector_HeaderFile

#ifndef _IntRes2d_IntersectionPoint_HeaderFile
#include <IntRes2d_IntersectionPoint.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _HLRBRep_CInter_HeaderFile
#include <HLRBRep_CInter.hxx>
#endif
#ifndef _HLRBRep_InterCSurf_HeaderFile
#include <HLRBRep_InterCSurf.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_UndefinedDerivative;
class gp_Lin;
class IntRes2d_IntersectionPoint;
class IntCurveSurface_IntersectionPoint;
class IntRes2d_IntersectionSegment;
class IntCurveSurface_IntersectionSegment;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The Intersector  computes 2D  intersections of the <br>
//!          projections of 3D curves. <br>
//! <br>
//!          It can also computes the intersection of a 3D line <br>
//!          and a surface. <br>
class HLRBRep_Intersector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT HLRBRep_Intersector();

//! Performs the auto  intersection  of  an edge. The <br>
//!          edge domain is cutted at start with da1*(b-a) and <br>
//!          at end with db1*(b-a). <br>
Standard_EXPORT   void Perform(const Standard_Address A1,const Standard_Real da1,const Standard_Real db1) ;

//! Performs the  intersection between the two edges. <br>
//!          The  edges  domains  are  cutted  at  start  with <br>
//!          da*(b-a) and at end with db*(b-a). <br>
Standard_EXPORT   void Perform(const Standard_Integer nA,const Standard_Address A1,const Standard_Real da1,const Standard_Real db1,const Standard_Integer nB,const Standard_Address A2,const Standard_Real da2,const Standard_Real db2,const Standard_Boolean NoBound) ;

//! Create a single IntersectionPoint (U on A1) (V on A2) <br>
//!          The point is middle on both curves. <br>
Standard_EXPORT   void SimulateOnePoint(const Standard_Address A1,const Standard_Real U,const Standard_Address A2,const Standard_Real V) ;


Standard_EXPORT   void Load(Standard_Address& A) ;


Standard_EXPORT   void Perform(const gp_Lin& L,const Standard_Real P) ;


Standard_EXPORT   Standard_Boolean IsDone() const;


Standard_EXPORT   Standard_Integer NbPoints() const;


Standard_EXPORT  const IntRes2d_IntersectionPoint& Point(const Standard_Integer N) const;


Standard_EXPORT  const IntCurveSurface_IntersectionPoint& CSPoint(const Standard_Integer N) const;


Standard_EXPORT   Standard_Integer NbSegments() const;


Standard_EXPORT  const IntRes2d_IntersectionSegment& Segment(const Standard_Integer N) const;


Standard_EXPORT  const IntCurveSurface_IntersectionSegment& CSSegment(const Standard_Integer N) const;


Standard_EXPORT   void Destroy() ;
~HLRBRep_Intersector()
{
  Destroy();
}






protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
IntRes2d_IntersectionPoint mySinglePoint;
Standard_Integer myTypePerform;
HLRBRep_CInter myIntersector;
HLRBRep_InterCSurf myCSIntersector;
Standard_Address mySurface;
Standard_Address myPolyhedron;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
