// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomAPI_ProjectPointOnCurve_HeaderFile
#define _GeomAPI_ProjectPointOnCurve_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Extrema_ExtPC_HeaderFile
#include <Extrema_ExtPC.hxx>
#endif
#ifndef _GeomAdaptor_Curve_HeaderFile
#include <GeomAdaptor_Curve.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class gp_Pnt;
class Geom_Curve;
class Extrema_ExtPC;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements methods for  computing all the orthogonal <br>
//!  projections of a 3D point onto a  3D curve. <br>
class GeomAPI_ProjectPointOnCurve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty object. Use an <br>
//! Init function for further initialization. <br>
Standard_EXPORT GeomAPI_ProjectPointOnCurve();

//! Create the projection  of a  point  <P> on a curve <br>
//!          <Curve> <br>
Standard_EXPORT GeomAPI_ProjectPointOnCurve(const gp_Pnt& P,const Handle(Geom_Curve)& Curve);

//! Create  the projection  of a point <P>  on a curve <br>
//!          <Curve> limited by the two points of parameter Umin and Usup. <br>
Standard_EXPORT GeomAPI_ProjectPointOnCurve(const gp_Pnt& P,const Handle(Geom_Curve)& Curve,const Quantity_Parameter Umin,const Quantity_Parameter Usup);

//! Init the projection  of a  point  <P> on a curve <br>
//!          <Curve> <br>
Standard_EXPORT   void Init(const gp_Pnt& P,const Handle(Geom_Curve)& Curve) ;

//! Init  the  projection  of a  point <P>  on a curve <br>
//!          <Curve> limited by the two points of parameter Umin and Usup. <br>
Standard_EXPORT   void Init(const gp_Pnt& P,const Handle(Geom_Curve)& Curve,const Quantity_Parameter Umin,const Quantity_Parameter Usup) ;

//! Init  the  projection  of a  point <P>  on a curve <br>
//!          <Curve> limited by the two points of parameter Umin and Usup. <br>
Standard_EXPORT   void Init(const Handle(Geom_Curve)& Curve,const Quantity_Parameter Umin,const Quantity_Parameter Usup) ;

//! Performs the projection of a point on the current curve. <br>
Standard_EXPORT   void Perform(const gp_Pnt& P) ;

//! Returns the number of computed <br>
//! orthogonal projection points. <br>
//! Note: if this algorithm fails, NbPoints returns 0. <br>
Standard_EXPORT   Standard_Integer NbPoints() const;
Standard_EXPORT operator Standard_Integer() const;

//! Returns the orthogonal projection <br>
//! on the curve. Index is a number of a computed point. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ 1,NbPoints ], where <br>
//! NbPoints is the number of solution points. <br>
Standard_EXPORT   gp_Pnt Point(const Standard_Integer Index) const;

//! Returns the parameter on the curve <br>
//! of the point, which is the orthogonal projection. Index is a <br>
//! number of a computed point. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ 1,NbPoints ], where <br>
//! NbPoints is the number of solution points. <br>
Standard_EXPORT   Quantity_Parameter Parameter(const Standard_Integer Index) const;

//! Returns the parameter on the curve <br>
//! of the point, which is the orthogonal projection. Index is a <br>
//! number of a computed point. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ 1,NbPoints ], where <br>
//! NbPoints is the number of solution points.- <br>
Standard_EXPORT   void Parameter(const Standard_Integer Index,Quantity_Parameter& U) const;

//! Computes the distance between the <br>
//! point and its orthogonal projection on the curve. Index is a number of a computed point. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ 1,NbPoints ], where <br>
//! NbPoints is the number of solution points. <br>
Standard_EXPORT   Quantity_Length Distance(const Standard_Integer Index) const;

//! Returns the nearest orthogonal <br>
//! projection of the point on the curve. <br>
//! Exceptions: StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   gp_Pnt NearestPoint() const;
Standard_EXPORT operator gp_Pnt() const;

//! Returns the parameter on the curve <br>
//! of the nearest orthogonal projection of the point. <br>
//! Exceptions: StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   Quantity_Parameter LowerDistanceParameter() const;

//! Computes the distance between the <br>
//! point and its nearest orthogonal projection on the curve. <br>
//! Exceptions: StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   Quantity_Length LowerDistance() const;
Standard_EXPORT operator Standard_Real() const;
//! return the algorithmic object from Extrema <br>
 const Extrema_ExtPC& Extrema() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myIsDone;
Standard_Integer myIndex;
Extrema_ExtPC myExtPC;
GeomAdaptor_Curve myC;


};


#include <GeomAPI_ProjectPointOnCurve.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
