// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2d_Transformation_HeaderFile
#define _Geom2d_Transformation_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom2d_Transformation_HeaderFile
#include <Handle_Geom2d_Transformation.hxx>
#endif

#ifndef _gp_Trsf2d_HeaderFile
#include <gp_Trsf2d.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_TrsfForm_HeaderFile
#include <gp_TrsfForm.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_ConstructionError;
class Standard_OutOfRange;
class gp_Trsf2d;
class gp_Pnt2d;
class gp_Ax2d;
class gp_Vec2d;



//!  The class Transformation allows to create Translation, <br>
//!  Rotation, Symmetry, Scaling and complex transformations <br>
//!  obtained by combination of the previous elementary <br>
//!  transformations. <br>
//!  The Transformation class can also be used to <br>
//! construct complex transformations by combining <br>
//! these elementary transformations. <br>
//! However, these transformations can never change <br>
//! the type of an object. For example, the projection <br>
//! transformation can change a circle into an ellipse, <br>
//! and therefore change the real type of the object. <br>
//! Such a transformation is forbidden in this <br>
//! environment and cannot be a Geom2d_Transformation. <br>
//!  The transformation can be represented as follow : <br>
//! <br>
//!       V1   V2     T <br>
//!    | a11  a12    a14 |   | x |      | x'| <br>
//!    | a21  a22    a24 |   | y |      | y'| <br>
//!    |  0    0      1  |   | 1 |      | 1 | <br>
class Geom2d_Transformation : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an identity transformation. <br>
Standard_EXPORT Geom2d_Transformation();

//!  Creates a persistent copy of T. <br>
Standard_EXPORT Geom2d_Transformation(const gp_Trsf2d& T);


//!  Makes the transformation into a symmetrical transformation <br>
//!  with respect to a point P. <br>
//!  P is the center of the symmetry. <br>
Standard_EXPORT   void SetMirror(const gp_Pnt2d& P) ;


//!  Makes the transformation into a symmetrical transformation <br>
//!  with respect to an axis A. <br>
//!  A is the center of the axial symmetry. <br>
Standard_EXPORT   void SetMirror(const gp_Ax2d& A) ;

//! Assigns to this transformation the geometric <br>
//! properties of a rotation at angle Ang (in radians) about point P. <br>
Standard_EXPORT   void SetRotation(const gp_Pnt2d& P,const Standard_Real Ang) ;


//!  Makes the transformation into a scale. P is the center of <br>
//!  the scale and S is the scaling value. <br>
Standard_EXPORT   void SetScale(const gp_Pnt2d& P,const Standard_Real S) ;


//!  Makes a transformation allowing passage from the coordinate <br>
//!  system "FromSystem1" to the coordinate system "ToSystem2". <br>
Standard_EXPORT   void SetTransformation(const gp_Ax2d& FromSystem1,const gp_Ax2d& ToSystem2) ;


//!  Makes the transformation allowing passage from the basic <br>
//!  coordinate system <br>
//!  {P(0.,0.,0.), VX (1.,0.,0.), VY (0.,1.,0.)} <br>
//!  to the local coordinate system defined with the Ax2d ToSystem. <br>
Standard_EXPORT   void SetTransformation(const gp_Ax2d& ToSystem) ;


//!  Makes the transformation into a translation. <br>
//!  V is the vector of the translation. <br>
Standard_EXPORT   void SetTranslation(const gp_Vec2d& V) ;


//!  Makes the transformation into a translation from the point <br>
//!  P1 to the point P2. <br>
Standard_EXPORT   void SetTranslation(const gp_Pnt2d& P1,const gp_Pnt2d& P2) ;


//!  Makes the transformation into a transformation T from <br>
//!  package gp. <br>
Standard_EXPORT   void SetTrsf2d(const gp_Trsf2d& T) ;

//! Checks whether this transformation is an indirect <br>
//! transformation: returns true if the determinant of the <br>
//! matrix of the vectorial part of the transformation is less than 0. <br>
Standard_EXPORT   Standard_Boolean IsNegative() const;

//!  Returns the nature of this transformation as a value <br>
//! of the gp_TrsfForm enumeration. <br>
//!  Returns the nature of the transformation. It can be <br>
//!  Identity, Rotation, Translation, PntMirror, Ax1Mirror, <br>
//!  Scale, CompoundTrsf <br>
Standard_EXPORT   gp_TrsfForm Form() const;

//!  Returns the scale value of the transformation. <br>
Standard_EXPORT   Standard_Real ScaleFactor() const;

//! Converts this transformation into a gp_Trsf2d transformation. <br>
//!  Returns a non persistent copy of <me>. <br>
//! -C++: return const& <br>
Standard_EXPORT   gp_Trsf2d Trsf2d() const;


//!  Returns the coefficients of the global matrix of tranformation. <br>
//!  It is a 2 rows X 3 columns matrix. <br>
//!  Raised if  Row < 1 or Row > 2  or  Col < 1 or Col > 2 <br>
//!  Computes the reverse transformation. <br>
Standard_EXPORT   Standard_Real Value(const Standard_Integer Row,const Standard_Integer Col) const;

//! Computes the inverse of this transformation. <br>
//! and  assigns the result to this transformatio <br>
//!  Raised if the the transformation is singular. This means that <br>
//!  the ScaleFactor is lower or equal to Resolution from <br>
//!  package gp. <br>
Standard_EXPORT   void Invert() ;

//! Computes the inverse of this transformation and creates a new one. <br>
//!  Raises ConstructionError  if the the transformation is singular. This means that <br>
//!  the ScaleFactor is lower or equal to Resolution from package gp. <br>
Standard_EXPORT   Handle_Geom2d_Transformation Inverted() const;


//!  Computes the transformation composed with Other and <me>. <br>
//!  <me> * Other. <br>
//!  Returns a new transformation <br>
Standard_EXPORT   Handle_Geom2d_Transformation Multiplied(const Handle(Geom2d_Transformation)& Other) const;
  Handle_Geom2d_Transformation operator *(const Handle(Geom2d_Transformation)& Other) const
{
  return Multiplied(Other);
}



//!  Computes the transformation composed with Other and <me> . <br>
//!  <me> = <me> * Other. <br>
//!  Computes the following composition of transformations <br>
//!  if N > 0  <me> * <me> * .......* <me>. <br>
//!  if N = 0  Identity <br>
//!  if N < 0  <me>.Invert() * .........* <me>.Invert() <br>
Standard_EXPORT   void Multiply(const Handle(Geom2d_Transformation)& Other) ;
  void operator *=(const Handle(Geom2d_Transformation)& Other) 
{
  Multiply(Other);
}



//!  Raised if N < 0 and if the transformation is not inversible <br>
Standard_EXPORT   void Power(const Standard_Integer N) ;


//!  Raised if N < 0 and if the transformation is not inversible <br>
Standard_EXPORT   Handle_Geom2d_Transformation Powered(const Standard_Integer N) const;


//!  Computes the matrix of the transformation composed with <br>
//!  <me> and Other.     <me> = Other * <me> <br>
Standard_EXPORT   void PreMultiply(const Handle(Geom2d_Transformation)& Other) ;


//!  Applies the transformation <me> to the triplet {X, Y}. <br>
Standard_EXPORT   void Transforms(Standard_Real& X,Standard_Real& Y) const;

//! Creates a new object, which is a copy of this transformation. <br>
Standard_EXPORT   Handle_Geom2d_Transformation Copy() const;
//Standard_EXPORT ~Geom2d_Transformation();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Trsf2d gpTrsf2d;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
