// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2d_Curve_HeaderFile
#define _Geom2d_Curve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif

#ifndef _Geom2d_Geometry_HeaderFile
#include <Geom2d_Geometry.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_RangeError;
class Standard_NoSuchObject;
class Geom2d_UndefinedDerivative;
class Geom2d_UndefinedValue;
class gp_Trsf2d;
class gp_Pnt2d;
class gp_Vec2d;


//! The abstract class Curve describes the common <br>
//! behavior of curves in 2D space. The Geom2d <br>
//! package provides numerous concrete classes of <br>
//! derived curves, including lines, circles, conics, Bezier <br>
//! or BSpline curves, etc. <br>
//! The main characteristic of these curves is that they <br>
//! are parameterized. The Geom2d_Curve class shows: <br>
//! - how to work with the parametric equation of a <br>
//!   curve in order to calculate the point of parameter <br>
//!   u, together with the vector tangent and the <br>
//!   derivative vectors of order 2, 3,..., N at this point; <br>
//! - how to obtain general information about the curve <br>
//!   (for example, level of continuity, closed <br>
//!   characteristics, periodicity, bounds of the parameter field); <br>
//! - how the parameter changes when a geometric <br>
//!   transformation is applied to the curve or when the <br>
//!   orientation of the curve is inverted. <br>
//! All curves must have a geometric continuity: a curve is <br>
//! at least "C0". Generally, this property is checked at <br>
//! the time of construction or when the curve is edited. <br>
//! Where this is not the case, the documentation <br>
//! explicitly states so. <br>
//! Warning <br>
//! The Geom2d package does not prevent the <br>
//! construction of curves with null length or curves which <br>
//! self-intersect. <br>
class Geom2d_Curve : public Geom2d_Geometry {

public:
 // Methods PUBLIC
 // 


//!  Changes the direction of parametrization of <me>. <br>
//!  The "FirstParameter" and the "LastParameter" are not changed <br>
//!  but the orientation  of the curve is modified. If the curve <br>
//!  is bounded the StartPoint of the initial curve becomes the <br>
//!  EndPoint of the reversed curve  and the EndPoint of the initial <br>
//!  curve becomes the StartPoint of the reversed curve. <br>
Standard_EXPORT virtual  void Reverse()  = 0;

//! Computes the parameter on the reversed curve for <br>
//! the point of parameter U on this curve. <br>
//! Note: The point of parameter U on this curve is <br>
//! identical to the point of parameter <br>
//! ReversedParameter(U) on the reversed curve. <br>
Standard_EXPORT virtual  Standard_Real ReversedParameter(const Standard_Real U) const = 0;

//! Computes the parameter on the curve transformed by <br>
//! T for the point of parameter U on this curve. <br>
//! Note: this function generally returns U but it can be <br>
//! redefined (for example, on a line). <br>
Standard_EXPORT virtual  Standard_Real TransformedParameter(const Standard_Real U,const gp_Trsf2d& T) const;

//! Returns the coefficient required to compute the <br>
//! parametric transformation of this curve when <br>
//! transformation T is applied. This coefficient is the <br>
//! ratio between the parameter of a point on this curve <br>
//! and the parameter of the transformed point on the <br>
//! new curve transformed by T. <br>
//! Note: this function generally returns 1. but it can be <br>
//! redefined (for example, on a line). <br>
Standard_EXPORT virtual  Standard_Real ParametricTransformation(const gp_Trsf2d& T) const;

//! Creates a reversed duplicate Changes the orientation of this curve. The first and <br>
//! last parameters are not changed, but the parametric <br>
//! direction of the curve is reversed. <br>
//! If the curve is bounded: <br>
//! - the start point of the initial curve becomes the end <br>
//!   point of the reversed curve, and <br>
//! - the end point of the initial curve becomes the start <br>
//!   point of the reversed curve. <br>
//! - Reversed creates a new curve. <br>
Standard_EXPORT   Handle_Geom2d_Curve Reversed() const;

//! Returns the value of the first parameter. <br>
//!  Warnings : <br>
//!  It can be RealFirst or RealLast from package Standard <br>
//!  if the curve is infinite <br>
Standard_EXPORT virtual  Standard_Real FirstParameter() const = 0;

//! Value of the last parameter. <br>
//!  Warnings : <br>
//!  It can be RealFirst or RealLast from package Standard <br>
//!  if the curve is infinite <br>
Standard_EXPORT virtual  Standard_Real LastParameter() const = 0;

//! Returns true if the curve is closed. <br>
//!  Examples : <br>
//!  Some curves such as circle are always closed, others such as line <br>
//!  are never closed (by definition). <br>
//!  Some Curves such as OffsetCurve can be closed or not. These curves <br>
//!  are considered as closed if the distance between the first point <br>
//!  and the last point of the curve is lower or equal to the Resolution <br>
//!  from package gp wich is a fixed criterion independant of the <br>
//!  application. <br>
Standard_EXPORT virtual  Standard_Boolean IsClosed() const = 0;


//! Returns true if the parameter of the curve is periodic. <br>
//!  It is possible only if the curve is closed and if the <br>
//!  following relation is satisfied : <br>
//!  for each parametric value U the distance between the point <br>
//!  P(u) and the point P (u + T) is lower or equal to Resolution <br>
//!  from package gp, T is the period and must be a constant. <br>
//!  There are three possibilities : <br>
//!   . the curve is never periodic by definition (SegmentLine) <br>
//!   . the curve is always periodic by definition (Circle) <br>
//!   . the curve can be defined as periodic (BSpline). In this case <br>
//!     a function SetPeriodic allows you to give the shape of the <br>
//!     curve.  The general rule for this case is : if a curve can be <br>
//!     periodic or not the default periodicity set is non periodic <br>
//!     and you have to turn (explicitly) the curve into a periodic <br>
//!     curve  if you want the curve to be periodic. <br>
Standard_EXPORT virtual  Standard_Boolean IsPeriodic() const = 0;

//! Returns thne period of this curve. <br>//! raises if the curve is not periodic <br>
Standard_EXPORT virtual  Standard_Real Period() const;


//!  It is the global continuity of the curve : <br>
//!  C0 : only geometric continuity, <br>
//!  C1 : continuity of the first derivative all along the Curve, <br>
//!  C2 : continuity of the second derivative all along the Curve, <br>
//!  C3 : continuity of the third derivative all along the Curve, <br>
//!  G1 : tangency continuity all along the Curve, <br>
//!  G2 : curvature continuity all along the Curve, <br>
//!  CN : the order of continuity is infinite. <br>
Standard_EXPORT virtual  GeomAbs_Shape Continuity() const = 0;

//! Returns true if the degree of continuity of this curve is at least N. <br>
//! Exceptions Standard_RangeError if N is less than 0. <br>
Standard_EXPORT virtual  Standard_Boolean IsCN(const Standard_Integer N) const = 0;

//! Returns in P the point of parameter U. <br>
//!  If the curve is periodic  then the returned point is P(U) with <br>
//!  U = Ustart + (U - Uend)  where Ustart and Uend are the <br>
//!  parametric bounds of the curve. <br>
//!  Raised only for the "OffsetCurve" if it is not possible to <br>
//!  compute the current point. For example when the first <br>
//!  derivative on the basis curve and the offset direction <br>
//!  are parallel. <br>
Standard_EXPORT virtual  void D0(const Standard_Real U,gp_Pnt2d& P) const = 0;


//!  Returns the point P of parameter U and the first derivative V1. <br>//! Raised if the continuity of the curve is not C1. <br>
Standard_EXPORT virtual  void D1(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1) const = 0;


//!  Returns the point P of parameter U, the first and second <br>
//!  derivatives V1 and V2. <br>//! Raised if the continuity of the curve is not C2. <br>
Standard_EXPORT virtual  void D2(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2) const = 0;


//!  Returns the point P of parameter U, the first, the second <br>
//!  and the third derivative. <br>//! Raised if the continuity of the curve is not C3. <br>
Standard_EXPORT virtual  void D3(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2,gp_Vec2d& V3) const = 0;

//! For the point of parameter U of this curve, computes <br>
//! the vector corresponding to the Nth derivative. <br>
//! Exceptions <br>
//! StdFail_UndefinedDerivative if: <br>
//! - the continuity of the curve is not "CN", or <br>
//! - the derivative vector cannot be computed easily; <br>
//!   this is the case with specific types of curve (for <br>
//!   example, a rational BSpline curve where N is greater than 3). <br>
//!   Standard_RangeError if N is less than 1. <br>
Standard_EXPORT virtual  gp_Vec2d DN(const Standard_Real U,const Standard_Integer N) const = 0;

//! Computes the point of parameter U on <me>. <br>
//!  If the curve is periodic  then the returned point is P(U) with <br>
//!  U = Ustart + (U - Uend)  where Ustart and Uend are the <br>
//!  parametric bounds of the curve. <br>
//! <br>
//!  it is implemented with D0. <br>
//!  Raised only for the "OffsetCurve" if it is not possible to <br>
//!  compute the current point. For example when the first <br>
//!  derivative on the basis curve and the offset direction <br>
//!  are parallel. <br>
Standard_EXPORT   gp_Pnt2d Value(const Standard_Real U) const;
//Standard_EXPORT ~Geom2d_Curve();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
