// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GCE2d_MakeMirror_HeaderFile
#define _GCE2d_MakeMirror_HeaderFile

#ifndef _Handle_Geom2d_Transformation_HeaderFile
#include <Handle_Geom2d_Transformation.hxx>
#endif
class Geom2d_Transformation;
class gp_Pnt2d;
class gp_Ax2d;
class gp_Lin2d;
class gp_Dir2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements elementary construction algorithms for a <br>
//! symmetrical transformation in 2D space about a point <br>
//! or axis. The result is a Geom2d_Transformation transformation. <br>
//! A MakeMirror object provides a framework for: <br>
//! -   defining the construction of the transformation, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class GCE2d_MakeMirror  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT GCE2d_MakeMirror(const gp_Pnt2d& Point);


Standard_EXPORT GCE2d_MakeMirror(const gp_Ax2d& Axis);


Standard_EXPORT GCE2d_MakeMirror(const gp_Lin2d& Line);

//! Make a symetry transformation af axis defined by <br>
//!          <Point> and <Direc>. <br>
Standard_EXPORT GCE2d_MakeMirror(const gp_Pnt2d& Point,const gp_Dir2d& Direc);

//! Returns the constructed transformation. <br>
Standard_EXPORT  const Handle_Geom2d_Transformation& Value() const;


Standard_EXPORT  const Handle_Geom2d_Transformation& Operator() const;
Standard_EXPORT operator Handle_Geom2d_Transformation() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom2d_Transformation TheMirror;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
