// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _FEmTool_SparseMatrix_HeaderFile
#define _FEmTool_SparseMatrix_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_FEmTool_SparseMatrix_HeaderFile
#include <Handle_FEmTool_SparseMatrix.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_NotDone;
class math_Vector;


//! Sparse Matrix definition <br>
class FEmTool_SparseMatrix : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT virtual  void Init(const Standard_Real Value)  = 0;


Standard_EXPORT virtual  Standard_Real& ChangeValue(const Standard_Integer I,const Standard_Integer J)  = 0;

//! To make a Factorization of <me> <br>
Standard_EXPORT virtual  Standard_Boolean Decompose()  = 0;

//! Direct Solve of AX = B <br>
Standard_EXPORT virtual  void Solve(const math_Vector& B,math_Vector& X) const = 0;

//! Make Preparation to iterative solve <br>
Standard_EXPORT virtual  Standard_Boolean Prepare()  = 0;

//! Iterative solve  of AX = B <br>
Standard_EXPORT virtual  void Solve(const math_Vector& B,const math_Vector& Init,math_Vector& X,math_Vector& Residual,const Standard_Real Tolerance = 1.0e-8,const Standard_Integer NbIterations = 50) const = 0;

//! returns the product of a SparseMatrix by a vector. <br>
//!          An exception is raised if the dimensions are different <br>
Standard_EXPORT virtual  void Multiplied(const math_Vector& X,math_Vector& MX) const = 0;

//! returns the row range of a matrix. <br>
Standard_EXPORT virtual  Standard_Integer RowNumber() const = 0;

//! returns the column range of the matrix. <br>
Standard_EXPORT virtual  Standard_Integer ColNumber() const = 0;
//Standard_EXPORT ~FEmTool_SparseMatrix();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
