// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Extrema_GenLocateExtPS_HeaderFile
#define _Extrema_GenLocateExtPS_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Extrema_POnSurf_HeaderFile
#include <Extrema_POnSurf.hxx>
#endif
class Standard_DomainError;
class StdFail_NotDone;
class gp_Pnt;
class Adaptor3d_Surface;
class Extrema_POnSurf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! With a close point, it calculates the distance <br>
//!          between a point and a surface. <br>
//!          This distance can be a minimum or a maximum. <br>
class Extrema_GenLocateExtPS  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Extrema_GenLocateExtPS();

//! Calculates the distance with a close point. <br>
//!          The close point is defined by the parameter values <br>
//!          U0 and V0. <br>
//!          The function F(u,v)=distance(S(u,v),p) has an <br>
//!          extremun when gradient(F)=0. The algorithm searchs <br>
//!          a zero near the close point. <br>
Standard_EXPORT Extrema_GenLocateExtPS(const gp_Pnt& P,const Adaptor3d_Surface& S,const Standard_Real U0,const Standard_Real V0,const Standard_Real TolU,const Standard_Real TolV);

//! Returns True if the distance is found. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;

//! Returns the value of the extremum distance. <br>
Standard_EXPORT   Standard_Real Value() const;

//! Returns the point of the extremum distance. <br>
Standard_EXPORT   Extrema_POnSurf Point() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myDone;
Standard_Real myValue;
Extrema_POnSurf myPoint;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
