// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ChFiDS_Map_HeaderFile
#define _ChFiDS_Map_HeaderFile

#ifndef _TopTools_IndexedDataMapOfShapeListOfShape_HeaderFile
#include <TopTools_IndexedDataMapOfShapeListOfShape.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Encapsulation of IndexedDataMapOfShapeListOfShape. <br>
class ChFiDS_Map  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!  Create an empty Map <br>
Standard_EXPORT ChFiDS_Map();

//! Fills the map with the subshapes of type T1 as keys <br>
//!          and the list of ancestors  of type T2 as items. <br>
Standard_EXPORT   void Fill(const TopoDS_Shape& S,const TopAbs_ShapeEnum T1,const TopAbs_ShapeEnum T2) ;


Standard_EXPORT   Standard_Boolean Contains(const TopoDS_Shape& S) const;


Standard_EXPORT  const TopTools_ListOfShape& FindFromKey(const TopoDS_Shape& S) const;
 const TopTools_ListOfShape& operator()(const TopoDS_Shape& S) const
{
  return FindFromKey(S);
}



Standard_EXPORT  const TopTools_ListOfShape& FindFromIndex(const Standard_Integer I) const;
 const TopTools_ListOfShape& operator()(const Standard_Integer I) const
{
  return FindFromIndex(I);
}






protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopTools_IndexedDataMapOfShapeListOfShape myMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
