// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRep_TFace_HeaderFile
#define _BRep_TFace_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_BRep_TFace_HeaderFile
#include <Handle_BRep_TFace.hxx>
#endif

#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_Poly_Triangulation_HeaderFile
#include <Handle_Poly_Triangulation.hxx>
#endif
#ifndef _TopLoc_Location_HeaderFile
#include <TopLoc_Location.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopoDS_TFace_HeaderFile
#include <TopoDS_TFace.hxx>
#endif
#ifndef _Handle_TopoDS_TShape_HeaderFile
#include <Handle_TopoDS_TShape.hxx>
#endif
class Geom_Surface;
class Poly_Triangulation;
class TopLoc_Location;
class TopoDS_TShape;


//! The Tface from BRep  is  based  on the TFace  from <br>
//!          TopoDS. The TFace contains : <br>
//! <br>
//!          * A suface, a tolerance and a Location. <br>
//! <br>
//!          * A NaturalRestriction flag,   when this  flag  is <br>
//!          True the  boundary of the  face is known to be the <br>
//!          parametric space (Umin, UMax, VMin, VMax). <br>
//! <br>
//!          *  An    optional Triangulation.   If  there  is a <br>
//!          triangulation the surface can be absent. <br>
//! <br>
//!          The  Location is  used   for the Surface. <br>
//! <br>
//!          The triangulation  is in the same reference system <br>
//!          than the TFace.     A point on mySurface must   be <br>
//!          transformed with myLocation,  but  not a point  on <br>
//!          the triangulation. <br>
//! <br>
//!          The Surface may  be shared by different TFaces but <br>
//!          not the  Triangulation, because the  Triangulation <br>
//!          may be modified by  the edges. <br>
//! <br>
class BRep_TFace : public TopoDS_TFace {

public:
 // Methods PUBLIC
 // 

//! Creates an empty TFace. <br>
Standard_EXPORT BRep_TFace();

 const Handle_Geom_Surface& Surface() const;

 const Handle_Poly_Triangulation& Triangulation() const;

 const TopLoc_Location& Location() const;

  Standard_Real Tolerance() const;

  void Surface(const Handle(Geom_Surface)& S) ;

  void Triangulation(const Handle(Poly_Triangulation)& T) ;

  void Location(const TopLoc_Location& L) ;

  void Tolerance(const Standard_Real T) ;

  Standard_Boolean NaturalRestriction() const;

  void NaturalRestriction(const Standard_Boolean N) ;

//! Returns a copy  of the  TShape  with no sub-shapes. <br>
//!          The new Face has no triangulation. <br>
Standard_EXPORT virtual  Handle_TopoDS_TShape EmptyCopy() const;
//Standard_EXPORT ~BRep_TFace();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Surface mySurface;
Handle_Poly_Triangulation myTriangulation;
TopLoc_Location myLocation;
Standard_Real myTolerance;
Standard_Boolean myNaturalRestriction;


};


#include <BRep_TFace.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
