// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepExtrema_ExtPC_HeaderFile
#define _BRepExtrema_ExtPC_HeaderFile

#ifndef _Extrema_ExtPC_HeaderFile
#include <Extrema_ExtPC.hxx>
#endif
#ifndef _Handle_BRepAdaptor_HCurve_HeaderFile
#include <Handle_BRepAdaptor_HCurve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class BRepAdaptor_HCurve;
class StdFail_NotDone;
class Standard_OutOfRange;
class Standard_TypeMismatch;
class TopoDS_Vertex;
class TopoDS_Edge;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BRepExtrema_ExtPC  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepExtrema_ExtPC();

//! It calculates all the distances. <br>
Standard_EXPORT BRepExtrema_ExtPC(const TopoDS_Vertex& V,const TopoDS_Edge& E);


Standard_EXPORT   void Initialize(const TopoDS_Edge& E) ;

//! An exception is raised if the fields have not been <br>
//!          initialized. <br>
Standard_EXPORT   void Perform(const TopoDS_Vertex& V) ;

//! True if the distances are found. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;

//! Returns the number of extremum distances. <br>
Standard_EXPORT   Standard_Integer NbExt() const;

//! Returns True if the <N>th extremum distance is a <br>
//!          minimum. <br>
Standard_EXPORT   Standard_Boolean IsMin(const Standard_Integer N) const;

//! Returns the value of the <N>th extremum distance. <br>
Standard_EXPORT   Standard_Real Value(const Standard_Integer N) const;

//! Returns the parameter  on the  edge  of the  <N>th <br>
//!          extremum distance. <br>
Standard_EXPORT   Standard_Real Parameter(const Standard_Integer N) const;

//! Returns the Point of the <N>th extremum distance. <br>
Standard_EXPORT   gp_Pnt Point(const Standard_Integer N) const;

//! if the curve is a trimmed curve, <br>
//!          dist1 is the distance between <P> and the point <br>
//!          of parameter FirstParameter <pnt1> and <br>
//!          dist2 is the distance between <P> and the point <br>
//!          of parameter LastParameter <pnt2>. <br>
Standard_EXPORT   void TrimmedDistances(Standard_Real& dist1,Standard_Real& dist2,gp_Pnt& pnt1,gp_Pnt& pnt2) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Extrema_ExtPC myExtrem;
Handle_BRepAdaptor_HCurve myHC;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
