// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgo_AsDes_HeaderFile
#define _BRepAlgo_AsDes_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_BRepAlgo_AsDes_HeaderFile
#include <Handle_BRepAlgo_AsDes.hxx>
#endif

#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class TopoDS_Shape;
class TopTools_ListOfShape;


//! SD to store descendants and ascendants of Shapes. <br>
class BRepAlgo_AsDes : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an empty AsDes. <br>
Standard_EXPORT BRepAlgo_AsDes();


Standard_EXPORT   void Clear() ;

//! Stores <SS> as a futur subshape of <S>. <br>
Standard_EXPORT   void Add(const TopoDS_Shape& S,const TopoDS_Shape& SS) ;

//! Stores <SS> as futurs SubShapes of <S>. <br>
Standard_EXPORT   void Add(const TopoDS_Shape& S,const TopTools_ListOfShape& SS) ;


Standard_EXPORT   Standard_Boolean HasAscendant(const TopoDS_Shape& S) const;


Standard_EXPORT   Standard_Boolean HasDescendant(const TopoDS_Shape& S) const;

//! Returns the Shape containing <S>. <br>
Standard_EXPORT  const TopTools_ListOfShape& Ascendant(const TopoDS_Shape& S) const;

//! Returns futur subhapes of <S>. <br>
Standard_EXPORT  const TopTools_ListOfShape& Descendant(const TopoDS_Shape& S) const;

//! Returns futur subhapes of <S>. <br>
Standard_EXPORT   TopTools_ListOfShape& ChangeDescendant(const TopoDS_Shape& S) ;

//! Replace <OldS> by <NewS>. <br>
//!          <OldS> disapear from <me>. <br>
Standard_EXPORT   void Replace(const TopoDS_Shape& OldS,const TopoDS_Shape& NewS) ;

//! Remove <S> from me. <br>
Standard_EXPORT   void Remove(const TopoDS_Shape& S) ;

//! Returns  True if (S1> and <S2>  has  common <br>
//!           Descendants.  Stores in <LC> the Commons Descendants. <br>
Standard_EXPORT   Standard_Boolean HasCommonDescendant(const TopoDS_Shape& S1,const TopoDS_Shape& S2,TopTools_ListOfShape& LC) const;
//Standard_EXPORT ~BRepAlgo_AsDes();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Replace <OldS> by <NewS>. <br>
//!          <OldS> disapear from <me>. <br>
Standard_EXPORT   void BackReplace(const TopoDS_Shape& OldS,const TopoDS_Shape& NewS,const TopTools_ListOfShape& L,const Standard_Boolean InUp) ;


 // Fields PRIVATE
 //
TopTools_DataMapOfShapeListOfShape up;
TopTools_DataMapOfShapeListOfShape down;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
