// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_WireShell_HeaderFile
#define _BOP_WireShell_HeaderFile

#ifndef _BOP_WireShape_HeaderFile
#include <BOP_WireShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _BOP_Operation_HeaderFile
#include <BOP_Operation.hxx>
#endif
class BOPTools_DSFiller;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  The class to perform a Boolean Operations (BO) <br>
//!  Common,Cut,Fuse  between arguments when one of them is <br>
//!  a wire and other argument is a shell <br>
//! <br>
class BOP_WireShell  : public BOP_WireShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_WireShell();


//! See base classes, please <br>
Standard_EXPORT virtual  void Do() ;


//! See base classes, please <br>
Standard_EXPORT virtual  void DoWithFiller(const BOPTools_DSFiller& aDSF) ;


//! Destructor <br>
Standard_EXPORT virtual  void Destroy() ;
Standard_EXPORT virtual ~BOP_WireShell(){Destroy();}


//! See base classes, please <br>
Standard_EXPORT virtual  void BuildResult() ;


//! Check the types of arguments. <br>
//! Returns  FALSE if types of arguments <br>
//! are non-valid to be  treated by the <br>
//! agorithm <br>
Standard_EXPORT static  Standard_Boolean CheckArgTypes(const TopAbs_ShapeEnum theType1,const TopAbs_ShapeEnum theType2,const BOP_Operation theOperation) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


//! Internal  usage <br>
Standard_EXPORT   Standard_Boolean CheckArgTypes() const;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
