// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_WESCorrector_HeaderFile
#define _BOP_WESCorrector_HeaderFile

#ifndef _BOP_PWireEdgeSet_HeaderFile
#include <BOP_PWireEdgeSet.hxx>
#endif
#ifndef _BOP_WireEdgeSet_HeaderFile
#include <BOP_WireEdgeSet.hxx>
#endif
#ifndef _BOP_ListOfConnexityBlock_HeaderFile
#include <BOP_ListOfConnexityBlock.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class BOP_WireEdgeSet;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  The algorithm to change the Wire Edges Set (WES) contents. <br>
//!   The NewWES will contain only wires instead of wires and edges. <br>
class BOP_WESCorrector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_WESCorrector();


//! Modifier <br>
Standard_EXPORT   void SetWES(const BOP_WireEdgeSet& aWES) ;


//! Performs the algorithm that  consists  of  two  steps <br>
//! 1. Make conexity blocks (  DoConnexityBlocks()  ) <br>
//! 2. Make corrections     (  DoCorrections()  ) <br>
Standard_EXPORT   void Do() ;


//! Selector <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Selector <br>
//! contents see BOP_WESCorrector.cxx <br>
Standard_EXPORT   Standard_Integer ErrorStatus() const;


//! Selector <br>
Standard_EXPORT   BOP_WireEdgeSet& WES() ;


//! Selector <br>
Standard_EXPORT   BOP_WireEdgeSet& NewWES() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void DoConnexityBlocks() ;


Standard_EXPORT   void DoCorrections() ;


 // Fields PRIVATE
 //
BOP_PWireEdgeSet myWES;
BOP_WireEdgeSet myNewWES;
BOP_ListOfConnexityBlock myConnexityBlocks;
Standard_Boolean myIsDone;
Standard_Integer myErrorStatus;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
