// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_Interference_HeaderFile
#define _BOPTools_Interference_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BooleanOperations_KindOfInterference_HeaderFile
#include <BooleanOperations_KindOfInterference.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! class for storing information about an interference <br>
//!         that  takes  place  between  given  shape and shape <br>
//!         with  DS-index =aWith <br>
class BOPTools_Interference  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT BOPTools_Interference();

//!  constructor <br>
//! aWith  -  DS-index for the opposite shape <br>
//! aType  -  the type of the  interference <br>
//! anIndex-  the index of the result in corresponding <br>
//! interference table  (if the result is computed <br>
//! but there is no result  ->   anIndex=0) <br>
Standard_EXPORT BOPTools_Interference(const Standard_Integer aWith,const BooleanOperations_KindOfInterference aType,const Standard_Integer anIndex);


//! Modifier <br>
Standard_EXPORT   void SetWith(const Standard_Integer aWith) ;


//! Modifier <br>
Standard_EXPORT   void SetType(const BooleanOperations_KindOfInterference aType) ;


//! Modifier <br>
Standard_EXPORT   void SetIndex(const Standard_Integer anIndex) ;


//! Selector <br>
Standard_EXPORT   Standard_Integer With() const;


//! Selector <br>
Standard_EXPORT   BooleanOperations_KindOfInterference Type() const;


//! Selector <br>
Standard_EXPORT   Standard_Integer Index() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myWith;
BooleanOperations_KindOfInterference myType;
Standard_Integer myIndex;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
