// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AppDef_MyLineTool_HeaderFile
#define _AppDef_MyLineTool_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Approx_Status_HeaderFile
#include <Approx_Status.hxx>
#endif
class AppDef_MultiLine;
class TColgp_Array1OfPnt;
class TColgp_Array1OfPnt2d;
class TColgp_Array1OfVec;
class TColgp_Array1OfVec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class AppDef_MyLineTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns the first index of multipoints of the MultiLine. <br>
Standard_EXPORT static  Standard_Integer FirstPoint(const AppDef_MultiLine& ML) ;

//! Returns the last index of multipoints of the MultiLine. <br>
Standard_EXPORT static  Standard_Integer LastPoint(const AppDef_MultiLine& ML) ;

//! Returns the number of 2d points of a MultiLine. <br>
Standard_EXPORT static  Standard_Integer NbP2d(const AppDef_MultiLine& ML) ;

//! Returns the number of 3d points of a MultiLine. <br>
Standard_EXPORT static  Standard_Integer NbP3d(const AppDef_MultiLine& ML) ;

//! returns the 3d points of the multipoint <MPointIndex> <br>
//!          when only 3d points exist. <br>
Standard_EXPORT static  void Value(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfPnt& tabPt) ;

//! returns the 2d points of the multipoint <MPointIndex> <br>
//!          when only 2d points exist. <br>
Standard_EXPORT static  void Value(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfPnt2d& tabPt2d) ;

//! returns the 3d and 2d points of the multipoint <br>
//!          <MPointIndex>. <br>
Standard_EXPORT static  void Value(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfPnt& tabPt,TColgp_Array1OfPnt2d& tabPt2d) ;

//! returns the 3d points of the multipoint <MPointIndex> <br>
//!          when only 3d points exist. <br>
Standard_EXPORT static  Standard_Boolean Tangency(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfVec& tabV) ;

//! returns the 2d tangency points of the multipoint <br>
//!          <MPointIndex> only when 2d points exist. <br>
Standard_EXPORT static  Standard_Boolean Tangency(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfVec2d& tabV2d) ;

//! returns the 3d and 2d points of the multipoint <br>
//!          <MPointIndex>. <br>
Standard_EXPORT static  Standard_Boolean Tangency(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfVec& tabV,TColgp_Array1OfVec2d& tabV2d) ;

//! returns the 3d curvatures of the multipoint <MPointIndex> <br>
//!          when only 3d points exist. <br>
Standard_EXPORT static  Standard_Boolean Curvature(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfVec& tabV) ;

//! returns the 2d curvatures of the multipoint <br>
//!          <MPointIndex> only when 2d points exist. <br>
Standard_EXPORT static  Standard_Boolean Curvature(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfVec2d& tabV2d) ;

//! returns the 3d and 2d curvatures of the multipoint <br>
//!          <MPointIndex>. <br>
Standard_EXPORT static  Standard_Boolean Curvature(const AppDef_MultiLine& ML,const Standard_Integer MPointIndex,TColgp_Array1OfVec& tabV,TColgp_Array1OfVec2d& tabV2d) ;

//!  returns NoPointsAdded <br>
Standard_EXPORT static  Approx_Status WhatStatus(const AppDef_MultiLine& ML,const Standard_Integer I1,const Standard_Integer I2) ;

//! Is never called in the algorithms. <br>
//!          Nothing is done. <br>
Standard_EXPORT static  AppDef_MultiLine& MakeMLBetween(const AppDef_MultiLine& ML,const Standard_Integer I1,const Standard_Integer I2,const Standard_Integer NbPMin) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
