(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*               Pierre Weis, projet Cristal, INRIA Rocquencourt       *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  only by permission.                                                *)
(*                                                                     *)
(***********************************************************************)
open Sys;;

exception Erreur;;

exception Mauvais_suffixe;;

let enlve_suffixe_cpr chane =
  let longueur = String.length chane in
  if longueur < 4 or String.sub chane (longueur - 4) 4 <> ".cpr"
  then raise Mauvais_suffixe
  else String.sub chane 0 (longueur - 4);;

let erreur = ref false;;

for i = 1 to Array.length argv - 1 do
  let (nom_entre, nom_sortie) =
    try
      (argv.(i), enlve_suffixe_cpr argv.(i))
    with Mauvais_suffixe ->
      (argv.(i) ^ ".cpr", argv.(i)) in
  try
    let entre =
      try
        open_in_bin nom_entre
      with Sys_error message ->
        prerr_endline
          ("Erreur  l'ouverture de " ^ nom_entre ^ " : " ^ message);
        raise Erreur in
    let sortie =
      try
        open_out_bin nom_sortie
      with Sys_error message ->
        close_in entre;
        prerr_endline
          ("Erreur  la cration de " ^ nom_sortie ^ " : " ^ message);
        raise Erreur in
    try
      Huffman.dcompresse entre sortie;
      close_in entre; close_out sortie; remove nom_entre
    with Sys_error message ->
      close_in entre; close_out sortie; remove nom_sortie;
      prerr_endline
        ("Erreur pendant la compression de " ^ nom_entre ^ " : " ^ message);
      raise Erreur
  with Erreur ->
    erreur := true
done;
exit (if !erreur then 2 else 0);;
