open Syntaxe;;
open Types;;
open Synthese;;

let type_arithmtique = schma_trivial
  (type_flche (type_produit type_int type_int) type_int)
and type_comparaison = schma_trivial
  (type_flche (type_produit type_int type_int) type_bool);;

let env_initial =
  ["+",  type_arithmtique; "-", type_arithmtique;
   "*",  type_arithmtique; "/", type_arithmtique;
   "=",  type_comparaison; "<>", type_comparaison;
   "<",  type_comparaison; ">", type_comparaison;
   "<=", type_comparaison; ">=", type_comparaison;
   "not", schma_trivial (type_flche type_bool type_bool);
   "read_int", schma_trivial (type_flche type_int type_int);
   "write_int", schma_trivial (type_flche type_int type_int)];;

let boucle () =
  let env_global = ref env_initial in
  let flux_d'entre = Stream.of_channel stdin in
  try
    while true do
      print_string "# "; flush stdout;
      try
        match lire_phrase flux_d'entre with
        | Expression expr ->
            let ty = type_exp !env_global expr in
            print_string "- : "; imprime_type ty;
            print_newline ()
        | Dfinition df ->
            let nouvel_env = type_df !env_global df in
            begin match nouvel_env with
            | (nom, schma) :: _ ->
                print_string nom; print_string " : ";
                imprime_schma schma; print_newline ()
            | _ -> failwith "mauvaise gestion des dfintions"
            end;
            env_global := nouvel_env
      with
      | Stream.Error s ->
          print_string ("Erreur de syntaxe: " ^ s); print_newline ()
      | Conflit (ty1, ty2) ->
          print_string "Incompatibilit de types entre ";
          imprime_type ty1; print_string " et ";
          imprime_type ty2; print_newline()
      | Circularit (var, ty) ->
          print_string "Impossible d'identifier ";
          imprime_type var; print_string " et ";
          imprime_type ty; print_newline()
      | Erreur msg ->
          print_string "Erreur de typage: "; print_string msg;
          print_newline ()
    done
  with Stream.Failure -> ();;

if not !Sys.interactive then boucle ();;
