(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*               Pierre Weis, projet Cristal, INRIA Rocquencourt       *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

(*                         E I G H T   Q U E E N S

 The Eight Queens Program, lazy version.

 How to set n queens on a chessboard of size n such that none
 can catch one each other.

 The program computes and prints the set of solutions
 (without removing symmetrical solutions).

 Program first compiled in ML V6.2 in 1987.

 Interesting exercise: change the program such as to be able to compute
 solutions for sizes greater than a few dozens.

*)

type 'a lval =
   | Val of 'a
   | Delayed of (unit -> 'a);;

let force = function
  |  Val v -> v
  |  Delayed f -> f ();;

type 'a llist =
   | Nil
   | Cons of 'a lcell

and 'a lcell = { mutable hd : 'a lval; mutable tl : 'a llist lval};;

let rec map f = function
  | Nil -> Nil
  | Cons { hd = x; tl = l} ->
     Cons { hd = Delayed (fun () -> (f (force x)));
            tl = Delayed (fun () -> map f (force l))};;

let rec interval n m =
 if n > m then Nil else n :: interval (n + 1) m;;

let rev_append l1 l2 =
  let rec loop accu = function
    | Nil -> accu
    | h :: t -> loop (h :: accu) t in
  loop l2 l1;;

(* This one is tail rec. *)
let filter_append p l l0 =
  let rec loop accu = function
    | Nil -> accu
    | h :: t -> if p h then loop (h :: accu) t else loop accu t in
  let rev_res = loop Nil l in
  rev_append rev_res l0;;

(* A functional tail rec version *)
let concmap f l =
  let rec loop accu = function
  | Nil -> accu
  | h :: t -> loop (f h accu) t in
  loop Nil l;;

let rec safe x d  = function
  | Nil -> true
  | h :: t ->
     x <> h && x <> h + d && x <> h - d && safe x (d + 1) t;;

let rec ok = function
  | Nil -> true
  | h :: t -> safe h 1 t;;

let find_solutions size =
 let line = interval 1 size in
 let rec gen n size =
   if n = 0 then [Nil] else
   concmap 
    (fun b -> filter_append ok (map (fun q -> q :: b) line))
    (gen (n - 1) size) in
 gen size size;;

let solnum = List.length (find_solutions 12);;

print_int solnum; print_newline();;
