/*
 *   meix439t.c -- Source file for Telephony Resources
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <port_types.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#include <meio_api.h>          /* include general MEIO info */
#include "meiomacs.h"          /* include vendor driver types and macros */
#include <meiogtwy.h>
#include "meix0439.h"          /* get resource defs and function protos */
#include <stdio.h>

/* =======================================================================
 *
 *  Define Telephony characteristics
 *
 * ======================================================================= */
MEIO_TAIOCONNCHAR MeioTAIOCharacteristics = {
  1        /* Caller ID IS supported */
  ,0        /* and is disabled */
  ,0        /* we do NOT support handset to phoneline */
  ,0        /* not used */
  ,0        /* supports only 1 country */
  ,0        /* USA Country Code */
  ,0        /* not used */
};


#if defined(WORLDTRADE_VERSION)
/*----------------------------------------------------------------------- */
/* begin WORLD TRADE section */
/*----------------------------------------------------------------------- */
#include <mwwttbl.h>      /* required for WT Table Access */
ULONG ulTAIOWTTABaddr=0;  /* address of TAIO's WorldTrade Table */
/*----------------------------------------------------------------------- */
/* end WORLD TRADE section */
/*----------------------------------------------------------------------- */
#endif

/*-----------------------------------------------------------------------
 *
 *   GetTeleState() - local function to sample and save locally the state of
 *                    VIO and TAIO ITCB inputs.  Data is saved in local
 *                    structures.
 *
 *----------------------------------------------------------------------- */
/* static struct
{
  USHORT HioCtl;
  USHORT InputCtl;
  USHORT ShActive;   
}  VioState = { 0,0,0 }; */
static struct
{
  USHORT DataFlag;
} TaioState = { 0 };


ULONG  ulTAIOCIDaddr=0;    /* address of TAIO's CallerID control */
USHORT TrueCallerIDSupport;

ULONG UpdateCallerID(HDSP hDsp, USHORT Modify, UINT Value)
{
  ULONG  ulRC;
  USHORT usTempVal;
  
  MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::UpdateCallerID entry\n");
  if (Modify) {
    MeioTAIOCharacteristics.CallerID_Enabled = Value;
  } /* endif */
  
  usTempVal = (MeioTAIOCharacteristics.CallerID_Enabled && TrueCallerIDSupport) ? 0xffff : 0; /* fade the Modem */
  
  if (ulTAIOCIDaddr) {
    ulRC = dspMemTransfer( hDsp,
			   ulTAIOCIDaddr,
			   &usTempVal,
			   1, DSP_MEMXFER_DATA_WRITE);
    if (ulRC) ulRC = 0x10000000 | (0x0fffffff & ulRC);
  }
  else ulRC = MEIO_NOERROR;   /* haven't set address, ignore it */
  MW_SYSLOG_2(TRACE_MEIO_SPECIFIC,"meix439t::UpdateCallerID exit ulRC %lx\n",ulRC);
  return ulRC;
}


/*-----------------------------------------------------------------------
 *
 *  Phoneline connection is fixed, report that it is always ON
 *  nothing else to do... other than standard reserve,release,etc.
 *
 *----------------------------------------------------------------------- */
static ULONG PhoneConnection(RF_ARGS)
{
  MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::PhoneConnection entry\n");
  /* Connection State is considered always ON */
  if (usMessage==mQUERYmsg && lParam1 == MEIO_CONNECTION_STATE) {
    *((LPLONG)lParam2) = ON;
    return(MEIO_NOERROR);
  }
  /* Connection Characteristics are contained in MeioTAIOCharacteristics */
  if (usMessage==mQUERYmsg && lParam1 == MEIO_CONNECTION_CHARACTERISTICS) {
    *((LPLONG)lParam2) = *(LPLONG)&MeioTAIOCharacteristics;
    return(MEIO_NOERROR);
  }
  MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::PhoneConnection direct call and exit\n");
  /* Connection Characteristics are contained in MeioTAIOCharacteristics */
  if (usMessage==mUPDATEmsg && lParam1 == MEIO_CONNECTION_CHARACTERISTICS) {
    return UpdateCallerID(pConnection->pMeioDsp->hDsp,1,
			  ((MEIO_TAIOCONNCHAR FAR *)&lParam2)->CallerID_Enabled);
  } else {
    return generic_cf(RF_ARGLIST);
  }
}

/*-----------------------------------------------------------------------
 *
 *   HandIn1 -> TeleOut1
 *
 *----------------------------------------------------------------------- */
ULONG FAR HandIn1_TeleOut1(RF_ARGS)
{
   ULONG ulRC = MEIO_NOERROR;
   MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::HandIn1_TeleOut1 entry\n");

   if ( CHECK_QUERY_CONNECTION ) {
     *((LPLONG)lParam2) = ON;    /* Assume all ports are ON for now */
   } else{
     ulRC = generic_cf(RF_ARGLIST);
   }
   MW_SYSLOG_2(TRACE_MEIO_SPECIFIC,"meix439t::HandIn1_TeleOut1 exit ulRC %lx\n",ulRC);
   return(ulRC);
}

ULONG FAR TeleIn1_TeleAdc1     (RF_ARGS) { return PhoneConnection(RF_ARGLIST); }

ULONG FAR TeleDac1_TeleOut1 (RF_ARGS)
{
  MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::TeleDac1_TeleOut1 entry+exit\n");
  return PhoneConnection(RF_ARGLIST);
}

/*-----------------------------------------------------------------------
 *
 *   SetupTAIO() - sets up TAIO BIOS interface.
 *
 *----------------------------------------------------------------------- */
ULONG SetupTAIO(PMEIO_DSP pD)
{
  ULONG      ulRC;
  int        ConnectFlag=0;
  USHORT     usTempVal;
  
#if defined(WORLDTRADE_VERSION)
/*-----------------------------------------------------------------------
 * begin WORLD TRADE section
 *----------------------------------------------------------------------- */
  ULONG      ulg3fax;
  long       i;
  USHORT        WTTABNumWords;
  unsigned short FAR *lpTAIO_Datablock;

  /* Load TAIO RING.DSP */
  /*   ulRC=dspLoadModule( pD->hDsp,"TaioRing.dsp","TaioRing",DSP_ACTIVATE_ACTIVE, */
  /*                       &hring); */

  /*   Now ask the WT Parameter Table Access code for the required ID */
  /*   Copied from meix042t.c */
  
  MW_SYSLOG_2(TRACE_MEIO_SPECIFIC,"meix439t::SetupTAIO entry pD %p\n",pD);
  
  i = WtQueryItem((char FAR *)0,      /* get default country ID */
		  WT_G3_FAX_CTRL,     /* get Coupler ID */
		  &ulg3fax);
  
  if (i) {
    ulRC =0x30000000 | (0x0fffffff & -i); /* convert to universal error code */
    return ulRC;
  }
  /*   MeioTAIOCharacteristics.CallerID = (ulg3fax & 8) ? 0 : 1; */
  TrueCallerIDSupport = (ulg3fax & 8) ? 0 : 1; /* negative logic */
  MeioTAIOCharacteristics.CallerID = 1;;
  
  MeioTAIOCharacteristics.CallerID_Enabled = 0;
  /*  The coupler matches the required ID, let's get the rest of the */
  /*  WT Data. */
  i = WtQueryField((char FAR*)0, WT_FIELD_TAIO, &lpTAIO_Datablock);
  if (i < 0) {
    if (i != WT_ERR_MEM_ALLOCATION) {   /* did we fail doing allocation? */
      WtFree(&lpTAIO_Datablock);      /* no, free the data */
    } /* endif */
    ulRC =0x30000000 | (0x0fffffff & -i); /* convert to universal error code */
    return ulRC;
  } /* endif */
  
   if (i > MEIO_TAIOBLOCKSIZE ) {
     WtFree(&lpTAIO_Datablock);      /* free the data */
     return MEIO_NC_INVALID_TAIOREV; /* revision mismatch */
   }
   WTTABNumWords = (int)i;
   
   /*-----------------------------------------------------------------------
    * end WORLD TRADE section
    *----------------------------------------------------------------------- */
#endif
   /*   connect MEIO and TAIO ITCB */
   ulRC = dspConnectITCB(  0,   MEIO_TAIO_ITCB_NAME,
			   pD->hmTask,"MEIOTAIO_ITCB");
   
   
   
   /* get address of TAIO's ITCB */
   if (ulRC==DSP_NOERROR || ulRC == DSP_ITCB_CONNECTED) {
     ConnectFlag++;
     ulRC = dspMemTransfer ( pD->hDsp, pD->ulMEIO_TaioAddr,
			     &usTempVal,
			     1, DSP_MEMXFER_DATA_READ);
   }
   
   TaioBios.data.ITCB_Addr = usTempVal;

   /* get the task handle for later use */
   if (ulRC==DSP_NOERROR) {
     ulRC = dspNameToTaskHandle(pD->hMwaveMod,
				MEIO_TAIO_TASK_NAME,
				&TaioBios.data.hmTask);
   }
   
   if (ulRC==DSP_NOERROR) {
#if defined(WORLDTRADE_VERSION)
     /*-----------------------------------------------------------------------
      * begin WORLD TRADE section
      *----------------------------------------------------------------------- */
     
     /*   Put TAIO in STANDBY state so that it picks up the updated parameters. */
     dspChangeTaskState(TaioBios.data.hmTask ,DSP_ACTIVATE_STANDBY);
     
     /*-----------------------------------------------------------------------
      * end WORLD TRADE section
      *----------------------------------------------------------------------- */
#endif
     
     TaioBios.data.State = MEIO_OBJ_USED;    /* say we're successful */
     /* restore I/O connection */
     dspMemTransfer( pD->hDsp,
		     TaioBios.data.ITCB_Addr + MEIO_DATAFLAG_OFFSET,
		     &TaioState.DataFlag,
		     1, DSP_MEMXFER_DATA_WRITE);
     
     /* get address of TAIO's CallerID Enable control word */
     ulRC = dspLabelToAddress(TaioBios.data.hmTask, "TAIOCID",
			      &ulTAIOCIDaddr);
     
     if (ulRC==DSP_NOERROR) {
       UpdateCallerID(pD->hDsp,1,                                  
		      MeioTAIOCharacteristics.CallerID_Enabled);   
     } else {
       ulTAIOCIDaddr = 0;
       UpdateCallerID(pD->hDsp,1,0);  /* report disabled */
     } /* endif */
     ulRC = MEIO_NOERROR;     /* don't report back this error */
     
#if defined(WORLDTRADE_VERSION)
     /*-----------------------------------------------------------------------
      * begin WORLD TRADE section
      *----------------------------------------------------------------------- */
     /* get address of TAIO's World Trade Table */
     ulRC = dspLabelToAddress(TaioBios.data.hmTask, "WTTABLE",
			      &ulTAIOWTTABaddr);
     if (ulRC==DSP_NOERROR)
       ulRC = dspMemTransfer( pD->hDsp,
			      ulTAIOWTTABaddr,
			      lpTAIO_Datablock,
			      WTTABNumWords, DSP_MEMXFER_DATA_WRITE);
     
     /* send command which will provide sufficient time to insure set up */
     /*      WaitMeioCycle(pD); */
     
     /*   And Put TAIO back to ACTIVE state. */
     dspChangeTaskState(TaioBios.data.hmTask ,DSP_ACTIVATE_ACTIVE);
     
/*-----------------------------------------------------------------------
 * end WORLD TRADE section
 *----------------------------------------------------------------------- */
#endif

   } else {
     if (0 < ConnectFlag--)
       dspDisconnectITCB(  0,   MEIO_TAIO_ITCB_NAME,
			   pD->hmTask,"MEIOTAIO_ITCB");
     TaioBios.data.State = MEIO_OBJ_UNUSED;    /* say we're successful */
   }
   
#if defined(WORLDTRADE_VERSION)
   /*-----------------------------------------------------------------------
    * begin WORLD TRADE section
    *----------------------------------------------------------------------- */
   WtFree(&lpTAIO_Datablock);      /* free the data */
   /*-----------------------------------------------------------------------
    * end WORLD TRADE section
    *----------------------------------------------------------------------- */
#endif
   
   MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::SetupTAIO exit\n");
   if (ulRC) return (0x10000000 | (0x0fffffff & ulRC));
   return(ulRC);
}


/*-----------------------------------------------------------------------
 *
 *   TaioMethods() - handles reserve and release of TAIO BIOS by (un)loading
 *                   and (dis)connecting ITCBs
 *
 *----------------------------------------------------------------------- */
ULONG FAR TaioMethods(RF_ARGS)
{
  ULONG      ulRC;
  int        i;              /* max loop flag */
  USHORT     usAIC1SDval;
  USHORT     usTaioMode;
  PMEIO_DSP  pD;      /* local ptr for clarity */
  
  MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::TaioMethods entry\n");
  ulRC = generic_rf(RF_ARGLIST);    /* go through normal methods */
  if (ulRC)  return(ulRC);          /* no more if failure */
  
  
  switch (usMessage)
    {
      
    case mRESETmsg:
      TaioBios.data.State = MEIO_OBJ_UNUSED;  /* state of BIOS is unknown */
      break;
      
    case mREFRESHmsg:
      pD = pConnection->pMeioDsp;      /* setup local ptr */
      
      if (TaioBios.data.State == MEIO_OBJ_USED) {
	ulRC = SetupTAIO(pD);
      } /* endif */
      break;
      
    case mRESERVEmsg:
      pD = pConnection->pMeioDsp;      /* setup local ptr */
      
      if (TaioBios.data.State == MEIO_OBJ_UNUSED) {
	ulRC = SetupTAIO(pD);
      } /* endif */
      break;

    case mRELEASEmsg:
      pD = pConnection->pMeioDsp;      /* setup local ptr */
      
      /* is there something to release? */
      if (TaioBios.Resource.usOwnerCount == 0 &&
          TaioBios.data.State == MEIO_OBJ_USED) {
	
	/* before releasing, be sure to set DATAFLAG OFF */
	/*   reset HOOKCNTL also in case the task left it on */
	/*   no sense in leaving off hook. */
	TaioState.DataFlag = 0;
	DataFlag.data = OFF;
	dspMemTransfer( pD->hDsp,
			TaioBios.data.ITCB_Addr + MEIO_HOOKCNTL_OFFSET,
			&TaioState.DataFlag,
			1, DSP_MEMXFER_DATA_WRITE);
	dspMemTransfer( pD->hDsp,
			TaioBios.data.ITCB_Addr + MEIO_DATAFLAG_OFFSET,
			&TaioState.DataFlag,
			1, DSP_MEMXFER_DATA_WRITE);
	/*  now we must wait for both DATAFLAG and HOOKCNTL update to be */
	/*  reflected in hardware.  DATAFLAG is reflected in AIC1SD msb, */
	/*  while HOOKCNTL will be reflected in change of TAIO's state to */
	/*  <LINESEIZE. */
	/*  Wait for HS release first... */
	i = 32767;
	do {
	  dspMemTransfer( pD->hDsp,
			  AIC1SD,
			  &usAIC1SDval,
			  1, DSP_MEMXFER_DATA_READ);
	} while ( usAIC1SDval & HSRELAYBIT &&
		  i-- > 0 ); /* enddo */
	
	/*  Now, wait for return to ON HOOK state... */
	do {
	  dspMemTransfer( pD->hDsp,
			  TaioBios.data.ITCB_Addr + MEIO_TAIOMODE_OFFSET,
			  &usTaioMode,
			  1, DSP_MEMXFER_DATA_READ);
	} while ( usTaioMode >= MEIO_TAIO_LINESEIZE ); /* enddo */
	
	/* TAIO connected, disconnect our ITCB, and the ITCB with VIO. */
	/*    NOTE: VioBios() deals with 'behind the scenes' ITCBs */
	/*          for this adapter.  VioBios will disconnect when */
	/*          it is released.  Note that TAIO's use count won't */
	/*          go to 0 unless Vio is released or about to be. */
	/*          This is because Vio is dependent on Taio and therefor */
	/*          will be one of it's 'owners'. */
	dspDisconnectITCB(  0,   MEIO_TAIO_ITCB_NAME,
			    pD->hmTask,"MEIOTAIO_ITCB");
	
	
	/* reset Taio's state */
	TaioBios.data.State = MEIO_OBJ_UNUSED;    /* say we're successful */
	
      } /* endif */
      
      break;
    default:
      break;
    } /* endswitch */
  
  MW_SYSLOG_2(TRACE_MEIO_SPECIFIC,"meix439t::TaioMethods exit ulRC %lx\n",ulRC);
  return(ulRC);
}

void MEIO_Suspend(PMEIO_DSP pMeioDsp)
{
  USHORT     usTaioMode;
  PMEIO_DSP  pD;      /* local ptr for clarity */
  USHORT     Data_Flag=0;
  return;
  pD =pMeioDsp;      /* setup local ptr */
  
  MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::MEIO_Suspend entry\n");
  /* is there something to release? */
  if (TaioBios.Resource.usOwnerCount > 0 &&
      TaioBios.data.State == MEIO_OBJ_USED) {
    
    /* Force the TAIO to reset back to ON-HOOK */
    /* reset HOOKCNTL also in case the task left it on */
    /* no sense in leaving off hook. */
    
    dspMemTransfer( pD->hDsp,
		    TaioBios.data.ITCB_Addr + MEIO_HOOKCNTL_OFFSET,
		    &Data_Flag,
		    1, DSP_MEMXFER_DATA_WRITE);
    
    /*  Now, wait for return to ON HOOK state... */
    do {
      dspMemTransfer( pD->hDsp,
		      TaioBios.data.ITCB_Addr + MEIO_TAIOMODE_OFFSET,
		      &usTaioMode,
		      1, DSP_MEMXFER_DATA_READ);
    } while ( usTaioMode != MEIO_TAIO_OFFLINE ); /* enddo */
  }
  MW_SYSLOG_1(TRACE_MEIO_SPECIFIC,"meix439t::MEIO_Suspend exit\n");
}
