/*
 *   mwmquote.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include "mwmparse.h"
#include "mwmparsi.h"
#include "mnpitcb.h"
#include "v42itcb.h"
#include "stddef.h"

static char szThisFile[] = "mwmperc.c";


/*****************************************************************************/
/* mwmQuoteCommand                                                           */
/*****************************************************************************/
/* This routine is called when a Quote is encountered in the command         */
/* string.                                                                   */
/*                                                                           */
/* Here, we simply look at the next command character and call the           */
/* appropriate Quote command routine.                                        */
/*****************************************************************************/
USHORT mwmQuoteCommand(STATEINFO *psi)
{
  USHORT  usParm;
  USHORT  usParserStatus = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmquote::mwmQuoteCommand entry\n");
  /***************************************************************************/
  /* Look at this character in AT Command.                                   */
  /* Then advance index to point to next character.                          */
  /***************************************************************************/
  switch(psi->achCommandBuffer[psi->usNextATIndex++])
  {

    case 'H' :
      /***********************************************************************/
      /* This is a "H command.                                               */
      /* Portions of this command are allowed ("H0) at all times, so we will */
      /* do the check for V.42bis inside the HCommand routine.               */
      /***********************************************************************/
      /***********************************************************************/
      /* If the PP results of this command will fit into the buffer.         */
      /***********************************************************************/
      if ( (psi->usNextPPIndex + PP_QUOTE_H_CMD_SPACE) < PP_BUFFER_THRESHOLD)
      {
        /*********************************************************************/
        /* Get the parameter from the command string                         */
        /*********************************************************************/
        usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                            &psi->usNextATIndex);

        usParserStatus = mwmQuoteHCommand(psi, usParm);

      }
      else
      {
        /*********************************************************************/
        /* There is not enough room left in this PP Command buffer to        */
        /* process this command....                                          */
        /*********************************************************************/
        usParserStatus = MWM_GET_MORE_BUFFERS;
        psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
      }
      break;

    case 'N' :
      /***********************************************************************/
      /* This is an "N command.                                              */
      /* Only allow this command if V42BIS is installed.                     */
      /***********************************************************************/
      if (psi->ulFeaturesToLoad & FEATURE_V42BIS)
      {
        /*********************************************************************/
        /* If the PP results of this command will fit into the buffer.       */
        /*********************************************************************/
        if ( (psi->usNextPPIndex + PP_QUOTE_N_CMD_SPACE) < PP_BUFFER_THRESHOLD)
        {
          /*******************************************************************/
          /* Get the parameter from the command string                       */
          /*******************************************************************/
          usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                              &psi->usNextATIndex);

          usParserStatus = mwmQuoteNCommand(psi, usParm);

        }
        else
        {
          /*******************************************************************/
          /* There is not enough room left in this PP Command buffer to      */
          /* process this command....                                        */
          /*******************************************************************/
          usParserStatus = MWM_GET_MORE_BUFFERS;
          psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
        }
      }
      else
        usParserStatus = MWM_ATCMD_ERROR;
      break;

    case 'O' :
      /***********************************************************************/
      /* This is an "O command.                                              */
      /* Only allow this command if V42BIS is installed.                     */
      /***********************************************************************/
      if (psi->ulFeaturesToLoad & FEATURE_V42BIS)
      {
        /*********************************************************************/
        /* If the PP results of this command will fit into the buffer.       */
        /*********************************************************************/
        if ( (psi->usNextPPIndex + PP_QUOTE_O_CMD_SPACE) < PP_BUFFER_THRESHOLD)
        {
          /*******************************************************************/
          /* Get the parameter from the command string                       */
          /*******************************************************************/
          usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                              &psi->usNextATIndex);

          usParserStatus = mwmQuoteOCommand(psi, usParm);

        }
        else
        {
          /*******************************************************************/
          /* There is not enough room left in this PP Command buffer to      */
          /* process this command....                                        */
          /*******************************************************************/
          usParserStatus = MWM_GET_MORE_BUFFERS;
          psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
        }
      }
      else
        usParserStatus = MWM_ATCMD_ERROR;
      break;
    case '\0':
      break;

    default:
      usParserStatus = MWM_ATCMD_ERROR;
  }

  if (usParserStatus & MWM_GET_MORE_BUFFERS)
    /*************************************************************************/
    /* Move the AT Command Index back to this command to be parsed           */
    /* on the next interrupt.                                                */
    /*************************************************************************/
    psi->usNextATIndex--;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmquote::mwmQuoteCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}




/*****************************************************************************/
/* mwmQuoteHCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmQuoteCommand when...                                                 */
/*   Quote H command is encountered in the AT command string.                */
/*****************************************************************************/
USHORT  mwmQuoteHCommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  ULONG  ulRC;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmquote::mwmQuoteHCommand entry\n");

  /***************************************************************************/
  /* Only allow this command in its full function if V.42bis is installed    */
  /***************************************************************************/
  if (psi->ulFeaturesToLoad & FEATURE_V42BIS)
  {
    if (usParm<4)
    {
//        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x25 | psi->usParserMode);
//        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      mwmParseQueryModemRegisters(&Registers);
      Registers.QuoteH = usParm;
      mwmParseSetModemRegisters(&Registers);

//    DPF("Writing 0x%x to MNPITCB.RV42BIS (0x%04x)",usParm,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RV42BIS)));
      /*************************************************************************/
      /* Set MNPITCB.RV42BIS to the parameter.                                    */
      /*************************************************************************/
      ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RV42BIS),
                            &usParm, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                          MWM_DSP_ERROR, ulRC );
        return (USHORT)ulRC;
      }

//    DPF("Writing 0x%x to V42ITCB.Compctl (0x%04x)",usParm,((psi->dsp.dspaddrV42ITCB)+ offsetof(V42CTL, Compctl)));
      /*************************************************************************/
      /* Set V42ITCB.COMPCTL to the parameter.                                    */
      /*************************************************************************/
      ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrV42ITCB)+ offsetof(V42CTL, Compctl),
                            &usParm, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                          MWM_DSP_ERROR, ulRC );
        return (USHORT)ulRC;
      }
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;

  }
  else
  {
    /*************************************************************************/
    /* Allow only the "H0 command...and simply return ok for it.             */
    /*************************************************************************/
    if (usParm != 0)
      usParserStatus = MWM_ATCMD_ERROR;
    else
    {
//      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x25 | psi->usParserMode);
//      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0;
      mwmParseQueryModemRegisters(&Registers);
      Registers.QuoteH = usParm;
      mwmParseSetModemRegisters(&Registers);
//    DPF("Writing 0x%x to MNPITCB.RV42BIS (0x%04x)",usParm,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RV42BIS)));
      /*************************************************************************/
      /* Set MNPITCB.RV42BIS to the parameter.                                    */
      /*************************************************************************/
      ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RV42BIS),
                            &usParm, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                          MWM_DSP_ERROR, ulRC );
        return (USHORT)ulRC;
      }
//    DPF("Writing 0x%x to V42ITCB.Compctl (0x%04x)",usParm,((psi->dsp.dspaddrV42ITCB)+ offsetof(V42CTL, Compctl)));
      /*************************************************************************/
      /* Set V42ITCB.COMPCTL to the parameter.                                    */
      /*************************************************************************/
      ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrV42ITCB)+ offsetof(V42CTL, Compctl),
                            &usParm, 1,
                            DSP_MEMXFER_DATA_WRITE);
      if (ulRC!=DSP_NOERROR)
      {
        mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                          MWM_DSP_ERROR, ulRC );
        return (USHORT)ulRC;
      }
    }
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmquote::mwmQuoteHCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



/*****************************************************************************/
/* mwmQuoteNCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmQuoteCommand when...                                                 */
/*   Quote N command is encountered in the AT command string.                */
/*****************************************************************************/
USHORT  mwmQuoteNCommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;
  USHORT usRV42BN2Value = 0;
  USHORT usCOMPN2Value = 0;
  REGISTERS Registers;
  ULONG  ulRC;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmquote::mwmQuoteNCommand entry\n");
  switch (usParm)
  {
    case 0:
//      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x26 | psi->usParserMode);
//      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
      usRV42BN2Value = 512;
      usCOMPN2Value = 512;
      break;
    case 1:
      /***********************************************************************/
      /* MTS 3059                                                            */
      /* Make this command depend on the [FEATURES} V42BIS= INI keyword.     */
      /***********************************************************************/
      if ((psi->ulFeaturesToLoad & FEATURE_V42BIS_1024) ||
          (psi->ulFeaturesToLoad & FEATURE_V42BIS_2048) ||
          (psi->ulFeaturesToLoad & FEATURE_V42BIS_4096))
      {
//        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x26 | psi->usParserMode);
//        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
        usRV42BN2Value = 1024;
        usCOMPN2Value = 1024;
      }
      else
        usParserStatus = MWM_ATCMD_ERROR;
      break;
    case 2:
      /***********************************************************************/
      /* MTS 3059                                                            */
      /* Make this command depend on the [FEATURES} V42BIS= INI keyword.     */
      /***********************************************************************/
      if ((psi->ulFeaturesToLoad & FEATURE_V42BIS_2048) ||
          (psi->ulFeaturesToLoad & FEATURE_V42BIS_4096))
      {
//        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x26 | psi->usParserMode);
//        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
        usRV42BN2Value = 2048;
        usCOMPN2Value = 2048;
      }
      else
        usParserStatus = MWM_ATCMD_ERROR;
      break;
    case 3:
      /***********************************************************************/
      /* MTS 3059                                                            */
      /* Make this command depend on the [FEATURES} V42BIS= INI keyword.     */
      /***********************************************************************/
      if (psi->ulFeaturesToLoad & FEATURE_V42BIS_4096)
      {
//        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x26 | psi->usParserMode);
//        psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
        usRV42BN2Value = 4096;
        usCOMPN2Value = 4096;
      }
      else
        usParserStatus = MWM_ATCMD_ERROR;
      break;
    default:
      usParserStatus = MWM_ATCMD_ERROR;
  }

  if (!usParserStatus)
  {
    mwmParseQueryModemRegisters(&Registers);
    Registers.QuoteN = usParm;
    mwmParseSetModemRegisters(&Registers);

//  DPF("Writing 0x%x to MNPITCB.RV42BN2 (0x%04x)",usRV42BN2Value,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RV42BN2)));
    /*************************************************************************/
    /* Set MNPITCB.RV42BN2 to the parameter.                                    */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RV42BN2),
                          &usRV42BN2Value, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }

//  DPF("Writing 0x%x to V42ITCB.CompN2 (0x%04x)",usCOMPN2Value,((psi->dsp.dspaddrV42ITCB)+ offsetof(V42CTL, CompN2)));
    /*************************************************************************/
    /* Set V42ITCB.COMPN2 to the parameter.                                    */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrV42ITCB)+ offsetof(V42CTL, CompN2),
                          &usCOMPN2Value, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }

  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmquote::mwmQuoteNCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



/*****************************************************************************/
/* mwmQuoteOCommand                                                          */
/*****************************************************************************/
/* Called by...                                                              */
/*   mwmQuoteCommand when...                                                 */
/*   Quote O command is encountered in the AT command string.                */
/*****************************************************************************/
USHORT  mwmQuoteOCommand(STATEINFO *psi, USHORT usParm)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  ULONG  ulRC;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmquote::mwmQuoteOCommand entry\n");
  if ((usParm == 0) || ((usParm >= 6) && (usParm <= 250)) )
  {
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x27 | psi->usParserMode);
    /*************************************************************************/
    /* If the user doesn't put a parameter, or puts a 0, use 32 as the       */
    /* default.                                                              */
    /*************************************************************************/
    if (usParm == 0)
      usParm = 32;
//  psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
    mwmParseQueryModemRegisters(&Registers);
    Registers.QuoteO = usParm;
    mwmParseSetModemRegisters(&Registers);

//  DPF("Writing 0x%x to MNPITCB.RV42BN7 (0x%04x)",usParm,((psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RV42BN7)));
    /*************************************************************************/
    /* Set MNPITCB.RV42BN7 to the parameter.                                    */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrMNPITCB)+ offsetof(MNPITCB, RV42BN7),
                          &usParm, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }

//  DPF("Writing 0x%x to V42ITCB.CompN7 (0x%04x)",usParm,((psi->dsp.dspaddrV42ITCB)+ offsetof(V42CTL, CompN7)));
    /*************************************************************************/
    /* Set V42ITCB.COMPN7 to the parameter.                                    */
    /*************************************************************************/
    ulRC = dspMemTransfer(psi->dsp.hDSP, (psi->dsp.dspaddrV42ITCB)+ offsetof(V42CTL, CompN7),
                          &usParm, 1,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return (USHORT)ulRC;
    }
  }
  else
  {
    usParserStatus = MWM_ATCMD_ERROR;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmquote::mwmQuoteOCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

