/*
 *   mwmrsp.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmspcfc.h>
static char szThisFile[] = "MWMRSP.C";

ULONG mwmrspEchoFAXResponse(PMWM_DSPINFO pmwmDspInfo,USHORT usControlStat)
{
  ULONG ulRC = 0;


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspEchoFAXResponse entry\n");  }


  /***************************************************************************/
  /* Determine Which response we need to send...                             */
  /***************************************************************************/
  switch (usControlStat)
  {
    case 0x1000:
      ulRC = mwmrspFDISResponse(pmwmDspInfo, 1);
      if (ulRC)
        return ulRC;

      break;
    case 0x1001:
      ulRC = mwmrspFDCSResponse(pmwmDspInfo);
      if (ulRC)
        return ulRC;
      break;
    case 0x1002:
      ulRC = mwmrspFCSIResponse(pmwmDspInfo, 1);
      if (ulRC)
        return ulRC;
      break;
    case 0x1003:
      ulRC = mwmrspFCSIResponse(pmwmDspInfo, 0);
      if (ulRC)
        return ulRC;
      break;
    case 0x1004:
      ulRC = mwmrspFPTSResponse(pmwmDspInfo, TRUE);
      if (ulRC)
        return ulRC;
      break;
    case 0x1005:
      ulRC = mwmrspFPTSResponse(pmwmDspInfo, FALSE);
      if (ulRC)
        return ulRC;
      break;
    case 0x1007:
      ulRC = mwmrspFDISResponse(pmwmDspInfo, 0);
      if (ulRC)
        return ulRC;
      break;
    case 0x1008:
      ulRC = mwmrspFCSIResponse(pmwmDspInfo, 2);
      if (ulRC)
        return ulRC;
      break;
    case 0x1009:
      ulRC = mwmrspFHNGResponse(pmwmDspInfo);
      if (ulRC)
        return ulRC;
      break;
  }

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspEchoFAXResponse exit\n");  }

  return 0;
}





ULONG mwmrspEchoStringToATRLCBUF(PMWM_DSPINFO pmwmDspInfo, PSZ achString)
{
  ULONG  ulRC = 0;
  USHORT usNumChars = 0;
  USHORT usNextIndex = 0;
  ULONG  ulAddress = 0;
  USHORT ausATRLCBUF[AT_CMD_BUFFER_SIZE];
  #ifdef DEBUG
  USHORT usCount;
  char   pszDebugString[128];
  char   pszConvertString[10] = "\0";
  #endif


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspEchoStringToATRLCBUF entry\n");  }


  if (  (usNextIndex + strlen(achString)/2 + 5) < AT_CMD_BUFFER_SIZE)
  {
    /*************************************************************************/
    /* Add Command to suppress blank line                                    */
    /*************************************************************************/
    /*************************************************************************/
    /* Add the number of characters that will be echoed...                   */
    /*************************************************************************/
    usNumChars = strlen(achString);
    ausATRLCBUF[usNextIndex++] = usNumChars;

    /*************************************************************************/
    /* Copy in the character string...packing the characters into the        */
    /* word (USHORT) array.                                                  */
    /*************************************************************************/
    strcpy((char *)&ausATRLCBUF[usNextIndex],achString);

    swab((char *)&ausATRLCBUF[usNextIndex],
         (char *)&ausATRLCBUF[usNextIndex],((usNumChars+1)/2)*2);
    /*************************************************************************/
    /* advance the PP Index pointer.                                         */
    /*************************************************************************/
    usNextIndex += (usNumChars+1)/2;


    #ifdef DEBUG
    /***************************************************************************/
    /* Debug....write the PP command ...                                       */
    /***************************************************************************/
    strncpy(pszDebugString,"PP Cmd: (ATRLCBUF) ",128);
    for (usCount = 0;usCount<usNextIndex;usCount++)
    {
      sprintf(pszConvertString,"%x,",ausATRLCBUF[usCount]);
      strcat(pszDebugString,pszConvertString);
      if (strlen(pszDebugString)>80)
      {
        strcat(pszDebugString,"\n");
        if (usDebugWindow)
        {
          DPF(pszDebugString);
        }
        *pszDebugString = '\0';
      }
    }

    if (strlen(pszDebugString))
    {
      strcat(pszDebugString,"\n");
      if (usDebugWindow)
      {
        DPF(pszDebugString);
      }
    }
    #endif /* DEBUG */


    /***************************************************************************/
    /***************************************************************************/
    ulRC = dspLabelToAddress(pmwmDspInfo->hmctlTask, "ATRLCBUF", &ulAddress);
    if (ulRC)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return (ulRC);
    }



    /*************************************************************************/
    /* Write the PP command buffer to MDMCTL's ATRLCBUF public label.        */
    /*************************************************************************/
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP,
                          ulAddress,
                          ausATRLCBUF,
                          usNextIndex,
                          DSP_MEMXFER_DATA_WRITE);

    if (ulRC != DSP_NOERROR)
    {
      return ulRC;
    }
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   (ULONG)-1);
    return ulRC;
  }



	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspEchoStringToATRLCBUF exit\n");  }


  return 0;
}



/*****************************************************************************/
/* Use this same function for the FCSI, FTSI and FCIG responses.  The only   */
/* difference is the text (FCSI, FTSI or FCIG) in the response.              */
/*****************************************************************************/
ULONG mwmrspFCSIResponse(PMWM_DSPINFO pmwmDspInfo, USHORT usFCSIFlag)
{
  ULONG  ulRC = 0;
  ULONG  ulAddress = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   achTempString[AT_CMD_BUFFER_SIZE];

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFCSIResponse entry\n");  }



  memset(achString,0,AT_CMD_BUFFER_SIZE);
  memset(achTempString,0,AT_CMD_BUFFER_SIZE);

  /***************************************************************************/
  /* Query CSI Label...                                                      */
  /* 11/20/96 This used to use the CSIDIGIT label from FAXMAN                */
  /* Now, the CSI is stored in remoteID which is not public.                 */
  /* Instead, we refer to it as an offset from DAT_BUFF.                     */
  /* The T30 data is mapped as following:                                    */
  /*                                                                         */
  /* DAT_BUFF         dd      0w                                             */
  /*         PUBLIC  dat_buff                                                */
  /* dis              dd      4w     0     ; Contains DIS rcvr parms         */
  /* dcs              dd      4w     0     ; Contains DCS xmtr parms         */
  /* My_ID            dd     10w     '20'x ; Identification buffer           */
  /* My_CIG           dd     10w     '20'x ; Identification buffer           */
  /* remoteID         dd     10w     '20'x ; Identification buffer           */
  /*                                                                         */
  /* Therefore, the offset is 56 bytes (28 words) to the remoteID            */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "DAT_BUFF", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Read (CSI) Frame from T30                                              */
  /***************************************************************************/
  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress+56,
                        (USHORT *)achTempString, 10,
                        DSP_MEMXFER_DATA_READ);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


//  swab(achString,achTempString,20);

  /***************************************************************************/
  /* Prefix the Parameters with the Response text...                         */
  /***************************************************************************/
  if (usFCSIFlag == 1) {
    sprintf(achString,"+FCSI:\"%s\"",achTempString);
  } else if (usFCSIFlag == 0) {
    sprintf(achString,"+FTSI:\"%s\"",achTempString);
  } else if (usFCSIFlag == 2) {
    sprintf(achString,"+FCIG:\"%s\"",achTempString);
  } /* endif */

  ulRC = mwmrspEchoStringToATRLCBUF(pmwmDspInfo, achString);
  if (ulRC)
  {
    return(ulRC);
  }

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFCSIResponse exit\n");  }


  return 0;
}








ULONG mwmrspFDCSResponse(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG  ulRC = 0;
  ULONG  ulAddress = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   achFinalString[AT_CMD_BUFFER_SIZE];
  USHORT ausDISFrame[2];
  #ifdef DEBUG
  char   pszDebugString[80] = "\0";
  #endif


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFDCSResponse entry\n");  }


  memset(achString,0,AT_CMD_BUFFER_SIZE);
  memset(achFinalString,0,AT_CMD_BUFFER_SIZE);

  /***************************************************************************/
  /* Query DCS Label...                                                      */
  /* 11/20/96 Tim  Class 2 restructure                                       */
  /*                                                                         */
  /* dat_buff         dd      0w                                             */
  /*         PUBLIC  dat_buff                                                */
  /* dis              dd      4w     0     ; Contains DIS rcvr parms         */
  /* dcs              dd      4w     0     ; Contains DCS xmtr parms         */
  /* My_ID            dd     10w     '20'x ; Identification buffer           */
  /* My_CIG           dd     10w     '20'x ; Identification buffer           */
  /* remoteID         dd     10w     '20'x ; Identification buffer           */
  /*                                                                         */
  /* Therefore, the offset is 52 bytes (26 words) to the remoteID            */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "DAT_BUFF", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Read DIS(DCS) Frame from T30                                            */
  /***************************************************************************/
  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress+8,
                        ausDISFrame, 2,
                        DSP_MEMXFER_DATA_READ);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  #ifdef DEBUG
  /***************************************************************************/
  /* Debug....write the DCS Frame Info command ...                           */
  /***************************************************************************/
  sprintf(pszDebugString,"DCS[0]=0x%04x DCS[1]=0x%04x\n",
          ausDISFrame[0],
          ausDISFrame[1]);

    if (usDebugWindow)
    {
      DPF(pszDebugString);
    }
  #endif /* DEBUG */



  /***************************************************************************/
  /* Call Bit Manipulation routine to get Parameters from the DIS Frame.     */
  /* 01/29/97 - DR - Add flag parameter indicating that this function is     */
  /* to use the speed setting corresponding to FDCS, not FDIS/FDTC           */
  /***************************************************************************/
  ulRC = mwmClss2ParseDCSFrame(ausDISFrame,achString, 1);
  if (ulRC)
  {
    return(ulRC);
  }


  /***************************************************************************/
  /* Prefix the Parameters with the Response text...                         */
  /***************************************************************************/
  sprintf(achFinalString,"+FDCS:%s",achString);


  ulRC = mwmrspEchoStringToATRLCBUF(pmwmDspInfo, achFinalString);
  if (ulRC)
  {
    return(ulRC);
  }



	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFDCSResponse exit\n");  }



  return 0;
}




ULONG mwmrspFDISResponse(PMWM_DSPINFO pmwmDspInfo, USHORT usFDISFlag)
{
  ULONG  ulRC = 0;
  ULONG  ulAddress = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   achFinalString[AT_CMD_BUFFER_SIZE];
  USHORT ausDISFrame[2];
  #ifdef DEBUG
  char   pszDebugString[80] = "\0";
  #endif


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFDISResponse entry\n");  }


  memset(achString,0,AT_CMD_BUFFER_SIZE);
  memset(achFinalString,0,AT_CMD_BUFFER_SIZE);

  /***************************************************************************/
  /* Query DIS Label...                                                      */
  /* 11/20/96 Tim   Class 2 restructure                                      */
  /*                                                                         */
  /* dat_buff         dd      0w                                             */
  /*         PUBLIC  dat_buff                                                */
  /* dis              dd      4w     0     ; Contains DIS rcvr parms         */
  /* dcs              dd      4w     0     ; Contains DCS xmtr parms         */
  /* My_ID            dd     10w     '20'x ; Identification buffer           */
  /* My_CIG           dd     10w     '20'x ; Identification buffer           */
  /* remoteID         dd     10w     '20'x ; Identification buffer           */
  /*                                                                         */
  /* Therefore, the offset is 52 bytes (26 words) to the remoteID            */
  /***************************************************************************/
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "DAT_BUFF", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Read DIS Frame from T30                                                 */
  /***************************************************************************/
  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        ausDISFrame, 2,
                        DSP_MEMXFER_DATA_READ);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }


  #ifdef DEBUG
  /***************************************************************************/
  /* Debug....write the DIS Frame Info ...                                   */
  /***************************************************************************/
  sprintf(pszDebugString,"DIS[0]=0x%04x DIS[1]=0x%04x\n",
          ausDISFrame[0],
          ausDISFrame[1]);

    if (usDebugWindow)
    {
      DPF(pszDebugString);
    }
  #endif /* DEBUG */



  /***************************************************************************/
  /* Call Bit Manipulation routine to get Parameters from the DIS Frame.     */
  /* 01/29/97 - DR - Add flag parameter indicating that this function is     */
  /* to use the speed setting corresponding to FDIS/FDTC, not FDCS           */
  /***************************************************************************/
  ulRC = mwmClss2ParseDCSFrame(ausDISFrame,achString, 0);
  if (ulRC)
  {
    return(ulRC);
  }


  /***************************************************************************/
  /* Prefix the Parameters with the Response text...                         */
  /***************************************************************************/
  if (usFDISFlag == 1) {
    sprintf(achFinalString, "+FDIS:%s",achString);
  } else {
    sprintf(achFinalString, "+FDTC:%s",achString);
  } /* endif */


  ulRC = mwmrspEchoStringToATRLCBUF(pmwmDspInfo, achFinalString);
  if (ulRC)
  {
    return(ulRC);
  }


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFDISResponse exit\n");  }


  return 0;
}






ULONG mwmrspFPTSResponse(PMWM_DSPINFO pmwmDspInfo, BOOL bGetLineCount)
{
  ULONG  ulRC = 0;
  ULONG  ulAddress = 0;
  USHORT usLineCount = 0;
  USHORT usFPTSValue = 0;
  char   achString[AT_CMD_BUFFER_SIZE] = "\0";
  char   achSmallString[5] = "\0";

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFPTSResponse entry\n");  }


  /***************************************************************************/
  /* Query Line Count Label...                                               */
  /***************************************************************************/
  if (bGetLineCount) {
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtMHINT, "LINECNT", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    /***************************************************************************/
    /* Read LINECNT  from MHINT                                                */
    /***************************************************************************/
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          &usLineCount, 1,
                          DSP_MEMXFER_DATA_READ);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
  } /* endif */

  /***************************************************************************/
  /* Build response string                                                   */
  /***************************************************************************/
  strcpy(achString,"+FPTS:");

  /***************************************************************************/
  /* Query CAP_BUFF Label...                                                 */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "CAP_BUFF", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Read FPTS  from T30                                                     */
  /* 01/29/97 - DR - FPTS is at offset 22 in the CAPBUFF structure           */
  /***************************************************************************/
  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress+22,
                        &usFPTSValue, 1,
                        DSP_MEMXFER_DATA_READ);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Add the PPR value.                                                      */
  /***************************************************************************/
  sprintf(achSmallString, "%hu", usFPTSValue); /* paulsch */
  strcat( achString, achSmallString );
  /*strcat( achString, itoa(usFPTSValue, achSmallString, 10) );*/

  /***************************************************************************/
  /* Add the Line Count.                                                     */
  /***************************************************************************/
  if (bGetLineCount) {
    strcat( achString, ",");
    sprintf(achSmallString,"%hu",usLineCount);

    strcat(achString,achSmallString);
  } /* endif */


  ulRC = mwmrspEchoStringToATRLCBUF(pmwmDspInfo, achString);
  if (ulRC)
  {
    return(ulRC);
  }


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFPTSResponse exit\n");  }


  return 0;
}

#define FAX_TRACE_BUFFER_SIZE   256*sizeof(USHORT)

ULONG mwmrspFHNGResponse(PMWM_DSPINFO pmwmDspInfo)
{
  char   achString[AT_CMD_BUFFER_SIZE] = "\0";
  char   achTempBuffer[7];
  ULONG  ulRC = 0;
  ULONG  ulAddress;
  USHORT usFHNGValue;
  char   achTraceFilename[128];
  char   achBuffer[FAX_TRACE_BUFFER_SIZE];
  ULONG  ulBufferAddress = 0;
  FILE   *pOutputFile;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFHNGResponse entry\n");  }


  /***************************************************************************/
  /* Query FHNG Label...                                                     */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "FHNG", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************************/
  /* Read FHNG  from T30                                                     */
  /***************************************************************************/
  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        &usFHNGValue, 1,
                        DSP_MEMXFER_DATA_READ);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }

  ulRC = mwmParseSetFAXERR(usFHNGValue);
  if (ulRC) {
    return(ulRC);
  } /* endif */

  sprintf(achTempBuffer, "%d", usFHNGValue); /* paulsch */
  sprintf( achString, "+FHNG:%s", achTempBuffer );
  /*sprintf( achString, "+FHNG:%s", itoa( usFHNGValue, achTempBuffer, 10 ) );*/
  ulRC = mwmrspEchoStringToATRLCBUF(pmwmDspInfo, achString);
  if (ulRC) {
    return(ulRC);
  } /* endif */

  /****************************************************************
  ** If the debug flag is set, dump the contents of the trace
  ** buffer to an output file.
  *****************************************************************/
  if (usFHNGValue && GetPrivateProfileString("DEBUG","FAXDUMP","/tmp/FAXTRACE.DAT",
                                              achTraceFilename, sizeof(achTraceFilename),
                                              INIFile) ) {
    ulRC = dspLabelToAddress(pmwmDspInfo->hmtT30, "TRACEBUF", &ulAddress);
    if (ulRC == DSP_NOERROR) {

      ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                            &ulBufferAddress, 1,
                            DSP_MEMXFER_DATA_READ);

      if (ulRC == DSP_NOERROR) {
        ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulBufferAddress,
                              achBuffer, FAX_TRACE_BUFFER_SIZE/sizeof(USHORT),
                              DSP_MEMXFER_DATA_READ);

        if (ulRC == DSP_NOERROR) {
          pOutputFile = fopen(achTraceFilename, "wb");
          if (pOutputFile != NULL) {
            swab(achBuffer, achBuffer, FAX_TRACE_BUFFER_SIZE);
            fwrite(achBuffer, FAX_TRACE_BUFFER_SIZE, 1, pOutputFile);
            fclose(pOutputFile);
          } /* endif */
        } /* endif */
      } /* endif */
    } /* endif */
  } /* endif */

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmrsp::mwmrspFHNGResponse exit\n");  }


  return 0;
}

