/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  Xstdio.h

Description:
  Definitions to supplement non-ANSI C versions of stdio.h

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.2 $  $Date: 1997/10/14 14:09:06 $

----------------------------------------------------------------------*/

#ifndef Xstdio_h_
#define Xstdio_h_

#ifndef sun
#  ifdef __sun		/* For Sun SC4.0 cc compiler */
#    define sun
#  endif
#endif

#ifdef sun
#  ifndef __SVR4
#    define sunOS4
#  endif
#endif

/* Systems running the default cc Sun OS 4.1 compiler have non-ANSI
   header files which lack several definitions, typedef's, and explicit
   typing of the return type for several functions.
*/

#include <stdio.h>	/* System stdio.h */

/* SEEK_SET, SEEK_END, etc */
#ifndef SEEK_SET
#  include <unistd.h>
#endif

/* size_t */
#include <stdlib.h>

/* FILENAME_MAX */
#ifndef FILENAME_MAX
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

/* HPUX */
#ifdef hpux
#  undef FILENAME_MAX	/* Fix, defined in stdio.h as 14 */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Define return types for some standard functions */
#ifdef sunOS4

int fclose ();
int fflush ();
int fgetc ();
int fprintf ();
int fseek ();
size_t fread ();
void frewind ();
size_t fwrite ();
int printf ();
#define remove(fname)	unlink (fname)
int rename ();
void rewind ();
int sscanf ();
int ungetc ();
int vfprintf ();

/* Notes for SunOS 4:
   - ferror and feof are defines
   - sprintf returns char *
*/

#endif	/* sunOS4 */

/* fileno */
#ifdef sun
#  ifndef fileno	/* fileno is a #define in SunOS4 */
extern int fileno ();	/* fileno does not have a prototype in Solaris */
#  endif
#endif

#ifdef __cplusplus
}
#endif

#endif /* Xstdio_h_ */
