/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/
#pragma prototyped

/*
 * Written by Stephen North and Eleftherios Koutsofios.
 */

#include	"dot.h"
#ifdef HAVE_CONFIG_H
#include "gvconfig.h"
#endif
#include	<time.h>
#ifndef MSWIN32
#include	<unistd.h>
#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif

char *Info[] = {
    "dot",              /* Program */
    VERSION,            /* Version */
    DATE                /* Build Date */
};

static graph_t *G;

#ifndef MSWIN32
static void intr(int s)
{
	if (G) dotneato_write(G);
	dotneato_terminate();
	exit(1);
}
#endif

int main(int argc, char** argv)
{
	static graph_t *prev;

	dotneato_initialize(argc,argv);
#ifndef MSWIN32
	signal (SIGUSR1, toggle);
	signal (SIGINT, intr);
#endif

	while ((G = next_input_graph())) {
		if (prev) dot_cleanup(prev);
		prev = G;
		dot_layout(G);
		dotneato_write(G);
	}
	dotneato_terminate();
	return 1;
}	
