/* This file contains the static parts of the cdrecord align_test output.
 * The dynamic part has been moved to configure (xconfig.h), where it belongs.
 */
#ifndef	_UTYPES_H
#include <utypes.h>
#endif
#include <xconfig.h>

/*
 * There used to be a cast to an int but we get a warning from GCC.
 * This warning message from GCC is wrong.
 * Believe me that this macro would even be usable if I would cast to short.
 * In order to avoid this warning, we are now using UIntptr_t
 */
#define	xaligned(a, s)		((((UIntptr_t)(a)) & s) == 0 )
#define	x2aligned(a, b, s)	(((((UIntptr_t)(a)) | ((UIntptr_t)(b))) & s) == 0 )

#define	saligned(a)		xaligned(a, ALIGN_SMASK)
#define	s2aligned(a, b)		x2aligned(a, b, ALIGN_SMASK)

#define	ialigned(a)		xaligned(a, ALIGN_IMASK)
#define	i2aligned(a, b)		x2aligned(a, b, ALIGN_IMASK)

#define	laligned(a)		xaligned(a, ALIGN_LMASK)
#define	l2aligned(a, b)		x2aligned(a, b, ALIGN_LMASK)

#define	llaligned(a)		xaligned(a, ALIGN_LLMASK)
#define	ll2aligned(a, b)	x2aligned(a, b, ALIGN_LLMASK)

#define	faligned(a)		xaligned(a, ALIGN_FMASK)
#define	f2aligned(a, b)		x2aligned(a, b, ALIGN_FMASK)

#define	daligned(a)		xaligned(a, ALIGN_DMASK)
#define	d2aligned(a, b)		x2aligned(a, b, ALIGN_DMASK)

#define	paligned(a)		xaligned(a, ALIGN_PMASK)
#define	p2aligned(a, b)		x2aligned(a, b, ALIGN_PMASK)


/*
 * There used to be a cast to an int but we get a warning from GCC.
 * This warning message from GCC is wrong.
 * Believe me that this macro would even be usable if I would cast to short.
 * In order to avoid this warning, we are now using UIntptr_t
 */
#define	xalign(x, a, m)		( ((char *)(x)) + ( (a) - 1 - ((((UIntptr_t)(x))-1)&(m))) )

#define	salign(x)		xalign((x), ALIGN_SHORT, ALIGN_SMASK)
#define	ialign(x)		xalign((x), ALIGN_INT, ALIGN_IMASK)
#define	lalign(x)		xalign((x), ALIGN_LONG, ALIGN_LMASK)
#define	llalign(x)		xalign((x), ALIGN_LLONG, ALIGN_LLMASK)
#define	falign(x)		xalign((x), ALIGN_FLOAT, ALIGN_FMASK)
#define	dalign(x)		xalign((x), ALIGN_DOUBLE, ALIGN_DMASK)
#define	palign(x)		xalign((x), ALIGN_PTR, ALIGN_PMASK)
