static char util_c_rcsid[]="util.c,v 1.3 1994/12/01 14:46:04 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * util.c,v
 * Revision 1.3  1994/12/01  14:46:04  kerce
 * Solaris 2.x mods
 *
 * Revision 1.2  1994/06/22  15:48:28  kerce
 * For "CPU Usage Options" window, allow insertion/removal of defaults
 *   with the mere click of a button
 *
 * Better sanity checking for qusage/qacct's options
 *
 * Revision 1.1.1.1  1994/06/18  19:43:32  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#if defined(SYSV) || defined(SVR4)
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "stdstuff.h"
#include "util.h"

/*
 *  Method: TimeOfDayInSecs ()
 *
 *  Purpose: Get time of day in seconds.
 *
 *  Preconditions: none.
 *
 *  Postconditions: none.
 *
 *  Returns: -1 on failure, with errno set.  Otherwise, the time of day in
 *           seconds (see gettimeofday(2)).
 *
 *  Side Effects: none.
 */
long
TimeOfDayInSecs ()
{
  struct timeval Time;
  int gettimeofdayResult;

  DENTER ((DQS_EVENT, "TimeOfDayInSecs"));

  gettimeofdayResult = gettimeofday (&Time, (struct timezone *) NULL);
  if (gettimeofdayResult != 0)
    {
      /* errno is set. */
      DEXIT;
      return ((long) -1);
    }

  assert (Time.tv_sec >= 0);
  DEXIT;
  return ((long) Time.tv_sec);
}

char *
TimeC (clock)
     time_t *clock;
{
  char *CTime;
  int CTimeLen;

  DENTER ((DQS_EVENT, "TimeC"));

  CTime = ctime (&clock);
  CTimeLen = strlen (CTime);
  if (CTimeLen > 0)
    if (CTime[CTimeLen - 1] == '\n')
      CTime[CTimeLen - 1] = '\0';

  DEXIT;

  return (CTime);
}

void
DisplayArgs (argc, argv)
     int argc;
     char **argv;
{
  int argcOrig;

  DENTER ((DQS_EVENT, "DisplayArgs"));

  argcOrig = argc;

  fprintf (stderr, "argc = %d\n", argc);
  while (argc > 0)
    {
      fprintf (stderr, "argv[%d] = `%s'\n",
	       (argcOrig - argc), argv[argcOrig - argc]);
      argc--;
    }

  DEXIT;
}

char *
BuildAboutTextString (Title, Version, AboutTextString)
     char *Title;
     char *Version;
     char *AboutTextString;
{
  static char *BuiltString;
  static BOOLEAN DejaVu = FALSE;

  DENTER ((DQS_EVENT, "BuildAboutTextString"));

  if (DejaVu == FALSE)
    {
      BuiltString = (char *) calloc (1, (strlen (AboutTextString) + 255));
      sprintf (BuiltString, AboutTextString, Title, Version);

      DejaVu = TRUE;
    }

  DEXIT;
  return (BuiltString);
}

void
IStartStopCalc (Start, Days, IStart, IStop, StartupTimeOfDayInSecs)
     unsigned int Start;
     unsigned int Days;
     unsigned long int *IStart;
     unsigned long int *IStop;
     unsigned long int StartupTimeOfDayInSecs;
{
  unsigned long int DaysSecs, StartSecs;

  DENTER ((DQS_EVENT, "IStartStopCalc"));

  *IStop = StartupTimeOfDayInSecs;
  if (*IStop == -1)
    {
      Error (NULL, 0, errno, "FATAL ERROR: can't determine time of day");
      DEXIT;
      exit (EXIT_FAILURE);
    }
  
  DaysSecs = Days * SECSPERDAY;
  StartSecs = Start * SECSPERDAY;
  
  *IStart = *IStop - StartSecs;
  *IStop = *IStart + DaysSecs;

  DEXIT;
}

/*
 *  Method: BuildFileName ()
 *
 *  Purpose: Construct a DQS acct/stat file name.
 *
 *  Preconditions: Preprocessor definitions QMASTER_SPOOL_DIR, ACT_FILE, and
 *                 STAT_FILE exist as strings.
 *
 *                 FileType indicates accounting file or stat file.
 *
 *  Postconditions: none.
 *
 *  Returns: NULL if memory allocation failure.  Otherwise, a string
 *           representing the DQS acct/stat file name.
 *
 *  Side Effects: none.
 */
char *
BuildFileName (FileType)
     DQSFileType FileType;
{
  static char *Name;
  char *QMasterSpoolDir, *HostName, *AcctOrStat;
  unsigned int Len;
  static BOOLEAN DejaVu = FALSE;
  
  DENTER ((DQS_EVENT, "BuildFileName"));

  if (DejaVu == TRUE)
    {
      DEXIT;
      return ((char *) Name);
    }

  if (FileType == STATF)
    AcctOrStat = STAT_FILE;
  else
    AcctOrStat = ACT_FILE;

  if (STATIC_CONFIGURATION)
    QMasterSpoolDir = QMASTER_SPOOL_DIR;
  else
    QMasterSpoolDir = conf.qmaster_spool_dir;

  HostName = dqs_get_cell_wd (me.default_cell);
  if (HostName == (char *) NULL)
    {
      DEXIT;
      return ((char *) NULL);
    }

  /* 11 extra chars (Three `/'s, `qmaster', and a null char). */
  Len =
    strlen (QMasterSpoolDir) + strlen (AcctOrStat) + strlen (HostName) + 11;
      
  Name = (char *) calloc (1, Len * sizeof (char));
      
  if (Name != (char *) NULL)
    {
      sprintf (Name, "%s/qmaster/%s/%s", QMasterSpoolDir, HostName,
	       AcctOrStat);
    }

  DejaVu = TRUE;

  DEXIT;
  return ((char *) Name);
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
